/*
 * Decompiled with CFR 0.152.
 */
package com.power.doc.model;

import com.power.common.util.StringUtil;
import com.power.doc.model.ApiMethodDoc;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class ApiDoc
implements Comparable<ApiDoc> {
    public Integer order;
    private String name;
    private String alias;
    private String[] tags;
    private String group;
    private String packageName;
    private List<ApiMethodDoc> list;
    private String desc;
    private String link;
    private String author;
    private boolean isFolder;
    private List<ApiDoc> childrenApiDocs = new ArrayList<ApiDoc>();

    public static ApiDoc buildTagApiDoc(ApiDoc source, String tag, ApiMethodDoc methodDoc) {
        ApiDoc apiDoc = new ApiDoc();
        apiDoc.setAlias(source.getAlias());
        apiDoc.setLink(source.getLink());
        apiDoc.setDesc(tag);
        apiDoc.setAuthor(source.getAuthor());
        apiDoc.setPackageName(source.getPackageName());
        apiDoc.setName(tag);
        apiDoc.setList(new ArrayList<ApiMethodDoc>());
        ApiMethodDoc clone = methodDoc.clone();
        clone.setOrder(apiDoc.getList().size() + 1);
        apiDoc.getList().add(clone);
        return apiDoc;
    }

    public static ApiDoc buildGroupApiDoc(String group) {
        ApiDoc apiDoc = new ApiDoc();
        apiDoc.setFolder(true);
        apiDoc.setGroup(group);
        apiDoc.setName(group);
        apiDoc.setDesc(group);
        apiDoc.setChildrenApiDocs(new ArrayList<ApiDoc>());
        return apiDoc;
    }

    public String getAuthor() {
        return this.author;
    }

    public void setAuthor(String author) {
        this.author = author;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<ApiMethodDoc> getList() {
        return this.list;
    }

    public void setList(List<ApiMethodDoc> list) {
        this.list = list;
    }

    public String getDesc() {
        return this.desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public Integer getOrder() {
        return this.order;
    }

    public void setOrder(Integer order) {
        this.order = order;
    }

    public String getAlias() {
        return this.alias;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public String[] getTags() {
        return this.tags;
    }

    public void setTags(String[] tags) {
        this.tags = tags;
    }

    public String getLink() {
        if (StringUtil.isNotEmpty((String)this.link)) {
            return this.link;
        }
        return this.desc.replace(" ", "_").toLowerCase();
    }

    public void setLink(String link) {
        this.link = link;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    public String getGroup() {
        return this.group;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    public boolean isFolder() {
        return this.isFolder;
    }

    public void setFolder(boolean folder) {
        this.isFolder = folder;
    }

    public List<ApiDoc> getChildrenApiDocs() {
        return this.childrenApiDocs;
    }

    public void setChildrenApiDocs(List<ApiDoc> childrenApiDocs) {
        this.childrenApiDocs = childrenApiDocs;
    }

    @Override
    public int compareTo(ApiDoc o) {
        if (Objects.nonNull(o.getDesc())) {
            return this.desc.compareTo(o.getDesc());
        }
        return this.name.compareTo(o.getName());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        sb.append("\"order\":").append(this.order);
        sb.append(",\"name\":\"").append(this.name).append('\"');
        sb.append(",\"alias\":\"").append(this.alias).append('\"');
        sb.append(",\"list\":").append(this.list);
        sb.append(",\"desc\":\"").append(this.desc).append('\"');
        sb.append('}');
        return sb.toString();
    }
}

