/*
 * Decompiled with CFR 0.152.
 */
package com.github.sommeri.less4j.core.parser;

import com.github.sommeri.less4j.LessCompiler;
import com.github.sommeri.less4j.LessSource;
import com.github.sommeri.less4j.core.parser.CollectorTokenSource;
import com.github.sommeri.less4j.core.parser.HiddenTokenAwareTree;
import com.github.sommeri.less4j.core.parser.HiddenTokenAwareTreeAdaptor;
import com.github.sommeri.less4j.core.parser.LessLexer;
import com.github.sommeri.less4j.core.parser.LessParser;
import com.github.sommeri.less4j.core.parser.ListToTreeCombiner;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.antlr.runtime.ANTLRStringStream;
import org.antlr.runtime.CharStream;
import org.antlr.runtime.CommonToken;
import org.antlr.runtime.CommonTokenStream;
import org.antlr.runtime.ParserRuleReturnScope;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.TokenSource;
import org.antlr.runtime.TokenStream;
import org.antlr.runtime.tree.TreeAdaptor;

public class ANTLRParser {
    private final boolean isDebug = false;
    private static final List<Integer> KEEP_HIDDEN_TOKENS = Arrays.asList(155, 168);

    public ParseResult parseStyleSheet(String styleSheet, LessSource source) {
        return this.parse(styleSheet, source, InputType.STYLE_SHEET);
    }

    public ParseResult parseDeclaration(String declaration, LessSource source) {
        return this.parse(declaration, source, InputType.DECLARATION);
    }

    public ParseResult parseExpression(String expression, LessSource source) {
        return this.parse(expression, source, InputType.EXPRESSION);
    }

    public ParseResult parseTerm(String term, LessSource source) {
        return this.parse(term, source, InputType.TERM);
    }

    public ParseResult parseSelector(String selector, LessSource source) {
        return this.parse(selector, source, InputType.SELECTOR);
    }

    public ParseResult parseRuleset(String ruleset, LessSource source) {
        return this.parse(ruleset, source, InputType.RULESET);
    }

    private ParseResult parse(String input, LessSource source, InputType inputType) {
        try {
            ArrayList<LessCompiler.Problem> errors = new ArrayList<LessCompiler.Problem>();
            LessLexer lexer = this.createLexer(input, source, errors);
            CollectorTokenSource tokenSource = new CollectorTokenSource((TokenSource)lexer, KEEP_HIDDEN_TOKENS);
            LessParser parser = this.createParser(tokenSource, source, errors);
            ParserRuleReturnScope returnScope = inputType.parseTree(parser);
            HiddenTokenAwareTree ast = (HiddenTokenAwareTree)((Object)returnScope.getTree());
            this.merge(ast, tokenSource.getCollectedTokens());
            return new ParseResultImpl(ast, new ArrayList<LessCompiler.Problem>(errors));
        }
        catch (RecognitionException e) {
            throw new IllegalStateException("Recognition exception is never thrown, only declared.");
        }
    }

    private LessParser createParser(TokenSource tokenSource, LessSource source, List<LessCompiler.Problem> errors) {
        CommonTokenStream tokens = new CommonTokenStream(tokenSource);
        LessParser parser = new LessParser((TokenStream)tokens, errors);
        parser.setTreeAdaptor((TreeAdaptor)new HiddenTokenAwareTreeAdaptor(source));
        return parser;
    }

    private LessLexer createLexer(String expression, LessSource source, List<LessCompiler.Problem> errors) {
        ANTLRStringStream input = new ANTLRStringStream(expression);
        LessLexer lexer = new LessLexer(source, (CharStream)input, errors);
        return lexer;
    }

    private HiddenTokenAwareTree merge(HiddenTokenAwareTree ast, LinkedList<CommonToken> hiddenTokens) {
        ListToTreeCombiner combiner = new ListToTreeCombiner();
        combiner.associate(ast, hiddenTokens);
        return ast;
    }

    private static enum InputType {
        SELECTOR{

            @Override
            public ParserRuleReturnScope parseTree(LessParser parser) throws RecognitionException {
                return parser.selector();
            }
        }
        ,
        TERM{

            @Override
            public ParserRuleReturnScope parseTree(LessParser parser) throws RecognitionException {
                return parser.term();
            }
        }
        ,
        EXPRESSION{

            @Override
            public ParserRuleReturnScope parseTree(LessParser parser) throws RecognitionException {
                return parser.expr();
            }
        }
        ,
        DECLARATION{

            @Override
            public ParserRuleReturnScope parseTree(LessParser parser) throws RecognitionException {
                return parser.declaration();
            }
        }
        ,
        STYLE_SHEET{

            @Override
            public ParserRuleReturnScope parseTree(LessParser parser) throws RecognitionException {
                return parser.styleSheet();
            }
        }
        ,
        RULESET{

            @Override
            public ParserRuleReturnScope parseTree(LessParser parser) throws RecognitionException {
                return parser.ruleSet();
            }
        };


        public abstract ParserRuleReturnScope parseTree(LessParser var1) throws RecognitionException;
    }

    private class ParseResultImpl
    implements ParseResult {
        private final HiddenTokenAwareTree tree;
        private final List<LessCompiler.Problem> errors;

        public ParseResultImpl(HiddenTokenAwareTree tree, List<LessCompiler.Problem> errors) {
            this.tree = tree;
            this.errors = errors;
        }

        @Override
        public HiddenTokenAwareTree getTree() {
            return this.tree;
        }

        @Override
        public List<LessCompiler.Problem> getErrors() {
            return this.errors;
        }

        @Override
        public boolean hasErrors() {
            return this.getErrors() != null && !this.getErrors().isEmpty();
        }
    }

    public static interface ParseResult {
        public HiddenTokenAwareTree getTree();

        public List<LessCompiler.Problem> getErrors();

        public boolean hasErrors();
    }
}

