/*
 * Decompiled with CFR 0.152.
 */
package com.github.sylvainlaurent.maven.yamljsonvalidator;

import com.github.sylvainlaurent.maven.yamljsonvalidator.ValidationResult;
import com.github.sylvainlaurent.maven.yamljsonvalidator.ValidationService;
import com.github.sylvainlaurent.maven.yamljsonvalidator.ValidationSet;
import java.io.File;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

@Mojo(name="validate", defaultPhase=LifecyclePhase.PROCESS_SOURCES, threadSafe=true)
public class ValidateMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project}", required=true, readonly=true)
    private MavenProject project;
    @Parameter(defaultValue="${project.basedir}", required=true, readonly=true)
    private File basedir;
    @Parameter
    private ValidationSet[] validationSets;
    @Parameter(defaultValue="true")
    private boolean verbose;
    @Parameter(defaultValue="false")
    private boolean skip;
    @Parameter(name="allowEmptyFiles", defaultValue="false")
    private boolean allowEmptyFiles;
    @Parameter(defaultValue="true")
    private boolean detectDuplicateKeys;
    @Parameter(defaultValue="false")
    private boolean allowJsonComments;

    public void execute() throws MojoExecutionException {
        boolean encounteredError = false;
        if (this.skip) {
            this.getLog().info((CharSequence)"Skipping validation");
            return;
        }
        for (ValidationSet set : this.validationSets) {
            File[] files;
            ValidationService validationService = new ValidationService(set.getJsonSchema(), this.allowEmptyFiles, this.detectDuplicateKeys, this.allowJsonComments);
            for (File file : files = set.getFiles(this.basedir)) {
                ValidationResult result;
                if (this.verbose) {
                    this.getLog().info((CharSequence)("Validating file " + file));
                }
                if ((result = validationService.validate(file)).hasError()) {
                    encounteredError = true;
                }
                for (String msg : result.getMessages()) {
                    this.getLog().warn((CharSequence)msg);
                }
            }
        }
        if (encounteredError) {
            throw new MojoExecutionException("Some files are not valid, see previous logs");
        }
    }
}

