/*
 * Decompiled with CFR 0.152.
 */
package com.github.timm.cucumber.generate;

import com.github.timm.cucumber.generate.Plugin;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class OverriddenCucumberOptionsParameters {
    private List<String> tags;
    private List<String> glue;
    private boolean strict;
    private List<Plugin> plugins;
    private boolean monochrome;

    OverriddenCucumberOptionsParameters() {
    }

    public OverriddenCucumberOptionsParameters setTags(List<String> tags) {
        this.tags = OverriddenCucumberOptionsParameters.requireNoneBlank(tags, "The parameters 'tags' are missing or invalid");
        return this;
    }

    public OverriddenCucumberOptionsParameters setGlue(List<String> glue) {
        if (glue == null || glue.isEmpty()) {
            throw new IllegalArgumentException("The parameters 'glue' are missing or invalid");
        }
        this.glue = OverriddenCucumberOptionsParameters.requireNoneBlank(glue, "The parameters 'glue' are invalid");
        return this;
    }

    public OverriddenCucumberOptionsParameters setStrict(boolean strict) {
        this.strict = strict;
        return this;
    }

    public OverriddenCucumberOptionsParameters setPlugins(List<Plugin> plugins) {
        this.plugins = OverriddenCucumberOptionsParameters.requireNoDuplicateExtensions(plugins);
        return this;
    }

    private static List<Plugin> requireNoDuplicateExtensions(List<Plugin> plugins) {
        HashMap<String, Plugin> extension = new HashMap<String, Plugin>();
        for (Plugin plugin : plugins) {
            Plugin replaced;
            if (plugin.isNoOutput() || (replaced = extension.put(plugin.getOutputDirectory() + ":" + plugin.getExtension(), plugin)) == null) continue;
            throw new IllegalArgumentException("The cucumber plugin '" + plugin + "' is writing to the same " + "combination of outputDirectory and extension as '" + replaced + "'. Use the outputDirectories attribute to " + "specify a directory for each plugin");
        }
        return plugins;
    }

    public OverriddenCucumberOptionsParameters setMonochrome(boolean monochrome) {
        this.monochrome = monochrome;
        return this;
    }

    OverriddenCucumberOptionsParameters overridePlugins(List<Plugin> plugins) {
        if (!plugins.isEmpty()) {
            this.setPlugins(plugins);
        }
        return this;
    }

    OverriddenCucumberOptionsParameters overrideGlue(List<String> glue) {
        if (!glue.isEmpty()) {
            this.setGlue(glue);
        }
        return this;
    }

    OverriddenCucumberOptionsParameters overrideTags(List<String> tags) {
        if (!tags.isEmpty()) {
            this.setTags(tags);
        }
        return this;
    }

    OverriddenCucumberOptionsParameters overrideStrict(Boolean strict) {
        if (strict != null) {
            this.strict = strict;
        }
        return this;
    }

    OverriddenCucumberOptionsParameters overrideMonochrome(Boolean monochrome) {
        if (monochrome != null) {
            this.monochrome = monochrome;
        }
        return this;
    }

    public boolean isStrict() {
        return this.strict;
    }

    public List<Plugin> getPlugins() {
        return this.plugins;
    }

    public List<String> getTags() {
        return this.tags;
    }

    public boolean isMonochrome() {
        return this.monochrome;
    }

    public List<String> getGlue() {
        return this.glue;
    }

    private static List<String> requireNoneBlank(List<String> list, String message) {
        for (String element : list) {
            if (!StringUtils.isBlank((CharSequence)element)) continue;
            throw new IllegalArgumentException(message + ": " + list);
        }
        return list;
    }
}

