/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.http.ssl;

import com.github.tomakehurst.wiremock.common.ArrayFunctions;
import com.github.tomakehurst.wiremock.common.Exceptions;
import com.github.tomakehurst.wiremock.http.ssl.CertChainAndKey;
import com.github.tomakehurst.wiremock.http.ssl.CertificateGenerationUnsupportedException;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.SignatureException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.time.Period;
import java.time.ZonedDateTime;
import java.util.Date;
import java.util.Objects;
import java.util.Random;
import javax.net.ssl.SNIHostName;
import sun.security.x509.AlgorithmId;
import sun.security.x509.AuthorityKeyIdentifierExtension;
import sun.security.x509.BasicConstraintsExtension;
import sun.security.x509.CertificateAlgorithmId;
import sun.security.x509.CertificateExtensions;
import sun.security.x509.CertificateSerialNumber;
import sun.security.x509.CertificateValidity;
import sun.security.x509.CertificateVersion;
import sun.security.x509.CertificateX509Key;
import sun.security.x509.DNSName;
import sun.security.x509.GeneralName;
import sun.security.x509.GeneralNames;
import sun.security.x509.KeyIdentifier;
import sun.security.x509.KeyUsageExtension;
import sun.security.x509.SubjectAlternativeNameExtension;
import sun.security.x509.SubjectKeyIdentifierExtension;
import sun.security.x509.X500Name;
import sun.security.x509.X509CertImpl;
import sun.security.x509.X509CertInfo;

public class CertificateAuthority {
    private final X509Certificate[] certificateChain;
    private final PrivateKey key;

    public CertificateAuthority(X509Certificate[] certificateChain, PrivateKey key) {
        this.certificateChain = Objects.requireNonNull(certificateChain);
        if (certificateChain.length == 0) {
            throw new IllegalArgumentException("Chain must have entries");
        }
        this.key = Objects.requireNonNull(key);
    }

    public static CertificateAuthority generateCertificateAuthority() throws CertificateGenerationUnsupportedException {
        try {
            KeyPair pair = CertificateAuthority.generateKeyPair("RSA");
            String sigAlg = "SHA256WithRSA";
            X509CertInfo info = CertificateAuthority.makeX509CertInfo(sigAlg, "WireMock Local Self Signed Root Certificate", Period.ofYears(10), pair.getPublic(), CertificateAuthority.certificateAuthorityExtensions(pair.getPublic()));
            X509CertImpl certificate = CertificateAuthority.selfSign(info, pair.getPrivate(), sigAlg);
            return new CertificateAuthority(new X509Certificate[]{certificate}, pair.getPrivate());
        }
        catch (IOException | NoClassDefFoundError | NoSuchMethodError | VerifyError | InvalidKeyException | NoSuchAlgorithmException | NoSuchProviderException | SignatureException | CertificateException e) {
            throw new CertificateGenerationUnsupportedException("Your runtime does not support generating certificates at runtime", e);
        }
    }

    private static X509CertImpl selfSign(X509CertInfo info, PrivateKey privateKey, String sigAlg) throws CertificateException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
        X509CertImpl certificate = new X509CertImpl(info);
        certificate.sign(privateKey, sigAlg);
        return certificate;
    }

    private static CertificateExtensions certificateAuthorityExtensions(PublicKey publicKey) {
        try {
            KeyIdentifier keyId = new KeyIdentifier(publicKey);
            byte[] keyIdBytes = keyId.getIdentifier();
            CertificateExtensions extensions = new CertificateExtensions();
            extensions.set("AuthorityKeyIdentifier", new AuthorityKeyIdentifierExtension(keyId, null, null));
            extensions.set("BasicConstraints", new BasicConstraintsExtension(true, Integer.MAX_VALUE));
            KeyUsageExtension keyUsage = new KeyUsageExtension(new boolean[7]);
            keyUsage.set("key_certsign", true);
            keyUsage.set("crl_sign", true);
            extensions.set("KeyUsage", keyUsage);
            extensions.set("SubjectKeyIdentifier", new SubjectKeyIdentifierExtension(keyIdBytes));
            return extensions;
        }
        catch (IOException e) {
            return (CertificateExtensions)Exceptions.throwUnchecked(e, null);
        }
    }

    public X509Certificate[] certificateChain() {
        return this.certificateChain;
    }

    public PrivateKey key() {
        return this.key;
    }

    CertChainAndKey generateCertificate(String keyType, SNIHostName hostName) throws CertificateGenerationUnsupportedException {
        try {
            KeyPair pair = CertificateAuthority.generateKeyPair(keyType);
            String sigAlg = "SHA256With" + keyType;
            X509CertInfo info = CertificateAuthority.makeX509CertInfo(sigAlg, hostName.getAsciiName(), Period.ofYears(1), pair.getPublic(), CertificateAuthority.subjectAlternativeName(hostName));
            X509CertImpl certificate = this.sign(info);
            X509Certificate[] fullChain = ArrayFunctions.prepend(certificate, this.certificateChain);
            return new CertChainAndKey(fullChain, pair.getPrivate());
        }
        catch (IOException | NoClassDefFoundError | NoSuchMethodError | VerifyError | InvalidKeyException | NoSuchAlgorithmException | NoSuchProviderException | SignatureException | CertificateException e) {
            throw new CertificateGenerationUnsupportedException("Your runtime does not support generating certificates at runtime", e);
        }
    }

    private X509CertImpl sign(X509CertInfo info) throws CertificateException, IOException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
        X509Certificate issuerCertificate = this.certificateChain[0];
        info.set("issuer", issuerCertificate.getSubjectDN());
        X509CertImpl certificate = new X509CertImpl(info);
        certificate.sign(this.key, issuerCertificate.getSigAlgName());
        return certificate;
    }

    private static KeyPair generateKeyPair(String keyType) throws NoSuchAlgorithmException {
        KeyPairGenerator keyGen = KeyPairGenerator.getInstance(keyType);
        keyGen.initialize(2048, new SecureRandom());
        return keyGen.generateKeyPair();
    }

    private static X509CertInfo makeX509CertInfo(String sigAlg, String subjectName, Period validity, PublicKey publicKey, CertificateExtensions certificateExtensions) throws IOException, CertificateException, NoSuchAlgorithmException {
        ZonedDateTime start = ZonedDateTime.now();
        ZonedDateTime end = start.plus(validity);
        X500Name myname = new X500Name("CN=" + subjectName);
        X509CertInfo info = new X509CertInfo();
        info.set("version", new CertificateVersion(2));
        info.set("serialNumber", new CertificateSerialNumber(new Random().nextInt() & Integer.MAX_VALUE));
        info.set("algorithmID", new CertificateAlgorithmId(AlgorithmId.get(sigAlg)));
        info.set("subject", myname);
        info.set("key", new CertificateX509Key(publicKey));
        info.set("validity", new CertificateValidity(Date.from(start.toInstant()), Date.from(end.toInstant())));
        info.set("issuer", myname);
        info.set("extensions", certificateExtensions);
        return info;
    }

    private static CertificateExtensions subjectAlternativeName(SNIHostName hostName) {
        GeneralName name = new GeneralName(CertificateAuthority.dnsName(hostName));
        GeneralNames names = new GeneralNames();
        names.add(name);
        try {
            CertificateExtensions extensions = new CertificateExtensions();
            extensions.set("SubjectAlternativeName", new SubjectAlternativeNameExtension(names));
            return extensions;
        }
        catch (IOException e) {
            return (CertificateExtensions)Exceptions.throwUnchecked(e, null);
        }
    }

    private static DNSName dnsName(SNIHostName name) {
        try {
            return new DNSName(name.getAsciiName());
        }
        catch (IOException e) {
            return (DNSName)Exceptions.throwUnchecked(e, null);
        }
    }
}

