/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.matching;

import com.github.tomakehurst.wiremock.matching.ContentPattern;
import com.github.tomakehurst.wiremock.matching.MatchResult;
import java.util.Arrays;
import wiremock.com.fasterxml.jackson.annotation.JsonCreator;
import wiremock.com.fasterxml.jackson.annotation.JsonIgnore;
import wiremock.com.fasterxml.jackson.annotation.JsonProperty;
import wiremock.com.google.common.io.BaseEncoding;

public class BinaryEqualToPattern
extends ContentPattern<byte[]> {
    public BinaryEqualToPattern(byte[] expected) {
        super(expected);
    }

    @JsonCreator
    public BinaryEqualToPattern(@JsonProperty(value="binaryEqualTo") String expected) {
        this(BaseEncoding.base64().decode(expected));
    }

    @Override
    public MatchResult match(byte[] actual) {
        return MatchResult.of(Arrays.equals(actual, (byte[])this.expectedValue));
    }

    @Override
    @JsonIgnore
    public String getName() {
        return "binaryEqualTo";
    }

    @Override
    @JsonIgnore
    public String getExpected() {
        return BaseEncoding.base64().encode((byte[])this.expectedValue);
    }

    public String getBinaryEqualTo() {
        return this.getExpected();
    }

    public String toString() {
        return this.getName() + " " + this.getExpected();
    }
}

