/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.http;

import com.github.tomakehurst.wiremock.common.BinaryFile;
import com.github.tomakehurst.wiremock.common.FileSource;
import com.github.tomakehurst.wiremock.global.GlobalSettingsHolder;
import com.github.tomakehurst.wiremock.http.ProxyResponseRenderer;
import com.github.tomakehurst.wiremock.http.Response;
import com.github.tomakehurst.wiremock.http.ResponseDefinition;
import com.github.tomakehurst.wiremock.http.ResponseRenderer;
import com.google.common.base.Optional;

public class StubResponseRenderer
implements ResponseRenderer {
    private final FileSource fileSource;
    private final GlobalSettingsHolder globalSettingsHolder;
    private final ProxyResponseRenderer proxyResponseRenderer;

    public StubResponseRenderer(FileSource fileSource, GlobalSettingsHolder globalSettingsHolder, ProxyResponseRenderer proxyResponseRenderer) {
        this.fileSource = fileSource;
        this.globalSettingsHolder = globalSettingsHolder;
        this.proxyResponseRenderer = proxyResponseRenderer;
    }

    @Override
    public Response render(ResponseDefinition responseDefinition) {
        if (!responseDefinition.wasConfigured()) {
            return Response.notConfigured();
        }
        this.addDelayIfSpecifiedGloballyOrIn(responseDefinition);
        if (responseDefinition.isProxyResponse()) {
            return this.proxyResponseRenderer.render(responseDefinition);
        }
        return this.renderDirectly(responseDefinition);
    }

    private Response renderDirectly(ResponseDefinition responseDefinition) {
        Response.Builder responseBuilder = Response.response().status(responseDefinition.getStatus()).headers(responseDefinition.getHeaders()).fault(responseDefinition.getFault());
        if (responseDefinition.specifiesBodyFile()) {
            BinaryFile bodyFile = this.fileSource.getBinaryFileNamed(responseDefinition.getBodyFileName());
            responseBuilder.body(bodyFile.readContents());
        } else if (responseDefinition.specifiesBodyContent()) {
            if (responseDefinition.specifiesBinaryBodyContent()) {
                responseBuilder.body(responseDefinition.getByteBody());
            } else {
                responseBuilder.body(responseDefinition.getBody());
            }
        }
        return responseBuilder.build();
    }

    private void addDelayIfSpecifiedGloballyOrIn(ResponseDefinition response) {
        Optional<Integer> optionalDelay = this.getDelayFromResponseOrGlobalSetting(response);
        if (optionalDelay.isPresent()) {
            try {
                Thread.sleep(((Integer)optionalDelay.get()).intValue());
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    private Optional<Integer> getDelayFromResponseOrGlobalSetting(ResponseDefinition response) {
        Integer delay = response.getFixedDelayMilliseconds() != null ? response.getFixedDelayMilliseconds() : this.globalSettingsHolder.get().getFixedDelay();
        return Optional.fromNullable((Object)delay);
    }
}

