/**
 * Copyright 2019 Anthony Trinh
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package ch.qos.logback.classic;

import org.slf4j.Marker;
import org.slf4j.MarkerFactory;

public class ClassicConstants {
  public static final String LOGBACK_CONTEXT_SELECTOR = "logback.ContextSelector";

  /**
   * The maximum number of package separators (dots) that abbreviation
   * algorithms can handle. Class or logger names with more separators will have
   * their first MAX_DOTS parts shortened.
   *
   */
  public static final int MAX_DOTS = 16;

  /**
   * The default stack data depth computed during caller data extraction.
   */
  public static final int DEFAULT_MAX_CALLEDER_DATA_DEPTH = 8;

  public static final String FINALIZE_SESSION = "FINALIZE_SESSION";
  public static final Marker FINALIZE_SESSION_MARKER = MarkerFactory.getMarker(FINALIZE_SESSION);
}
