/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.util;

import ch.qos.logback.core.util.CharSequenceState;
import java.text.DateFormatSymbols;

class CharSequenceToRegexMapper {
    DateFormatSymbols symbols = DateFormatSymbols.getInstance();

    CharSequenceToRegexMapper() {
    }

    String toRegex(CharSequenceState charSequenceState) {
        int n = charSequenceState.occurrences;
        char c = charSequenceState.c;
        switch (charSequenceState.c) {
            case 'G': 
            case 'z': {
                return ".*";
            }
            case 'M': {
                if (n <= 2) {
                    return this.number(n);
                }
                if (n == 3) {
                    return this.getRegexForShortMonths();
                }
                return this.getRegexForLongMonths();
            }
            case 'D': 
            case 'F': 
            case 'H': 
            case 'K': 
            case 'S': 
            case 'W': 
            case 'd': 
            case 'h': 
            case 'k': 
            case 'm': 
            case 's': 
            case 'w': 
            case 'y': {
                return this.number(n);
            }
            case 'E': {
                if (n >= 4) {
                    return this.getRegexForLongDaysOfTheWeek();
                }
                return this.getRegexForShortDaysOfTheWeek();
            }
            case 'a': {
                return this.getRegexForAmPms();
            }
            case 'Z': {
                return "(\\+|-)\\d{4}";
            }
            case '.': {
                return "\\.";
            }
            case '\\': {
                throw new IllegalStateException("Forward slashes are not allowed");
            }
            case '\'': {
                if (n == 1) {
                    return "";
                }
                throw new IllegalStateException("Too many single quotes");
            }
        }
        if (n == 1) {
            return "" + c;
        }
        return c + "{" + n + "}";
    }

    private String number(int n) {
        return "\\d{" + n + "}";
    }

    private String getRegexForAmPms() {
        return this.symbolArrayToRegex(this.symbols.getAmPmStrings());
    }

    private String getRegexForLongDaysOfTheWeek() {
        return this.symbolArrayToRegex(this.symbols.getWeekdays());
    }

    private String getRegexForShortDaysOfTheWeek() {
        return this.symbolArrayToRegex(this.symbols.getShortWeekdays());
    }

    private String getRegexForLongMonths() {
        return this.symbolArrayToRegex(this.symbols.getMonths());
    }

    String getRegexForShortMonths() {
        return this.symbolArrayToRegex(this.symbols.getShortMonths());
    }

    private String symbolArrayToRegex(String[] stringArray) {
        int[] nArray = CharSequenceToRegexMapper.findMinMaxLengthsInSymbols(stringArray);
        return ".{" + nArray[0] + "," + nArray[1] + "}";
    }

    static int[] findMinMaxLengthsInSymbols(String[] stringArray) {
        int n = Integer.MAX_VALUE;
        int n2 = 0;
        for (String string : stringArray) {
            int n3 = string.length();
            if (n3 == 0) continue;
            n = Math.min(n, n3);
            n2 = Math.max(n2, n3);
        }
        return new int[]{n, n2};
    }
}

