/*
 * Decompiled with CFR 0.152.
 */
package com.github.tototoshi.csv;

import com.github.tototoshi.csv.CSVFormat;
import com.github.tototoshi.csv.CSVWriter$;
import com.github.tototoshi.csv.QUOTE_ALL$;
import com.github.tototoshi.csv.QUOTE_MINIMAL$;
import com.github.tototoshi.csv.QUOTE_NONE$;
import com.github.tototoshi.csv.QUOTE_NONNUMERIC$;
import com.github.tototoshi.csv.Quoting;
import java.io.Closeable;
import java.io.File;
import java.io.Flushable;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.Writer;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.StringOps$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001\u0005]e\u0001B\u000e\u001d\u0001\u0015B\u0001b\u000e\u0001\u0003\u0006\u0004%\t\u0002\u000f\u0005\ty\u0001\u0011\t\u0011)A\u0005s!AQ\b\u0001BC\u0002\u0013\ra\b\u0003\u0005D\u0001\t\u0005\t\u0015!\u0003@\u0011\u0015!\u0005\u0001\"\u0001F\u0011\u0019Q\u0005\u0001)A\u0005\u0017\"1a\n\u0001Q\u0001\n=CQ\u0001\u0017\u0001\u0005\u0002eCQ!\u0018\u0001\u0005\u0002eCQA\u0018\u0001\u0005\u0002}CQA\u001d\u0001\u0005\nMDQA\u001e\u0001\u0005\u0002]<Q!\u001f\u000f\t\u0002i4Qa\u0007\u000f\t\u0002mDQ\u0001\u0012\b\u0005\u0002}Dq!!\u0001\u000f\t\u0003\t\u0019\u0001C\u0004\u0002\u00029!\t!a\u0005\t\u000f\u0005\u0005a\u0002\"\u0001\u00020!9\u0011\u0011\u0001\b\u0005\u0002\u0005\u0005\u0003bBA\u0001\u001d\u0011\u0005\u0011\u0011\u000b\u0005\b\u0003\u0003qA\u0011AA-\u0011\u001d\t\tA\u0004C\u0001\u0003GBq!!\u0001\u000f\t\u0003\ti\u0007C\u0004\u0002\u00029!\t!!\u001f\t\u000f\u0005\u0005a\u0002\"\u0001\u0002\u0006\"9\u0011\u0011\u0001\b\u0005\u0002\u0005=%!C\"T-^\u0013\u0018\u000e^3s\u0015\tib$A\u0002dgZT!a\b\u0011\u0002\u0013Q|Go\u001c;pg\"L'BA\u0011#\u0003\u00199\u0017\u000e\u001e5vE*\t1%A\u0002d_6\u001c\u0001a\u0005\u0003\u0001M9\"\u0004CA\u0014-\u001b\u0005A#BA\u0015+\u0003\u0011a\u0017M\\4\u000b\u0003-\nAA[1wC&\u0011Q\u0006\u000b\u0002\u0007\u001f\nTWm\u0019;\u0011\u0005=\u0012T\"\u0001\u0019\u000b\u0005ER\u0013AA5p\u0013\t\u0019\u0004GA\u0005DY>\u001cX-\u00192mKB\u0011q&N\u0005\u0003mA\u0012\u0011B\u00127vg\"\f'\r\\3\u0002\r]\u0014\u0018\u000e^3s+\u0005I\u0004CA\u0018;\u0013\tY\u0004G\u0001\u0004Xe&$XM]\u0001\boJLG/\u001a:!\u0003\u00191wN]7biV\tq\b\u0005\u0002A\u00036\tA$\u0003\u0002C9\tI1i\u0015,G_Jl\u0017\r^\u0001\bM>\u0014X.\u0019;!\u0003\u0019a\u0014N\\5u}Q\u0011a)\u0013\u000b\u0003\u000f\"\u0003\"\u0001\u0011\u0001\t\u000bu*\u00019A \t\u000b]*\u0001\u0019A\u001d\u0002\u0017A\u0014\u0018N\u001c;Xe&$XM\u001d\t\u0003_1K!!\u0014\u0019\u0003\u0017A\u0013\u0018N\u001c;Xe&$XM]\u0001\u0012cV|G/Z'j]&l\u0017\r\\*qK\u000e\u001c\bc\u0001)T+6\t\u0011KC\u0001S\u0003\u0015\u00198-\u00197b\u0013\t!\u0016KA\u0003BeJ\f\u0017\u0010\u0005\u0002Q-&\u0011q+\u0015\u0002\u0005\u0007\"\f'/A\u0003dY>\u001cX\rF\u0001[!\t\u00016,\u0003\u0002]#\n!QK\\5u\u0003\u00151G.^:i\u0003!9(/\u001b;f\u00032dGC\u0001.a\u0011\u0015\t'\u00021\u0001c\u0003!\tG\u000e\u001c'j]\u0016\u001c\bcA2l]:\u0011A-\u001b\b\u0003K\"l\u0011A\u001a\u0006\u0003O\u0012\na\u0001\u0010:p_Rt\u0014\"\u0001*\n\u0005)\f\u0016a\u00029bG.\fw-Z\u0005\u0003Y6\u00141aU3r\u0015\tQ\u0017\u000bE\u0002dW>\u0004\"\u0001\u00159\n\u0005E\f&aA!os\u0006IqO]5uK:+\u0007\u0010\u001e\u000b\u00035RDQ!^\u0006A\u00029\faAZ5fY\u0012\u001c\u0018\u0001C<sSR,'k\\<\u0015\u0005iC\b\"B;\r\u0001\u0004q\u0017!C\"T-^\u0013\u0018\u000e^3s!\t\u0001eb\u0005\u0002\u000fyB\u0011\u0001+`\u0005\u0003}F\u0013a!\u00118z%\u00164G#\u0001>\u0002\t=\u0004XM\u001c\u000b\u0005\u0003\u000b\tI\u0001F\u0002H\u0003\u000fAQ!\u0010\tA\u0004}Bq!a\u0003\u0011\u0001\u0004\ti!\u0001\u0003gS2,\u0007cA\u0018\u0002\u0010%\u0019\u0011\u0011\u0003\u0019\u0003\t\u0019KG.\u001a\u000b\u0007\u0003+\tI\"a\u0007\u0015\u0007\u001d\u000b9\u0002C\u0003>#\u0001\u000fq\bC\u0004\u0002\fE\u0001\r!!\u0004\t\u000f\u0005u\u0011\u00031\u0001\u0002 \u0005AQM\\2pI&tw\r\u0005\u0003\u0002\"\u0005%b\u0002BA\u0012\u0003K\u0001\"!Z)\n\u0007\u0005\u001d\u0012+\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003W\tiC\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003O\tFCBA\u0019\u0003k\t9\u0004F\u0002H\u0003gAQ!\u0010\nA\u0004}Bq!a\u0003\u0013\u0001\u0004\ti\u0001C\u0004\u0002:I\u0001\r!a\u000f\u0002\r\u0005\u0004\b/\u001a8e!\r\u0001\u0016QH\u0005\u0004\u0003\u007f\t&a\u0002\"p_2,\u0017M\u001c\u000b\u0005\u0003\u0007\n9\u0005F\u0002H\u0003\u000bBQ!P\nA\u0004}Bq!!\u0013\u0014\u0001\u0004\tY%A\u0002g_N\u00042aLA'\u0013\r\ty\u0005\r\u0002\r\u001fV$\b/\u001e;TiJ,\u0017-\u001c\u000b\u0005\u0003'\n9\u0006F\u0002H\u0003+BQ!\u0010\u000bA\u0004}Bq!a\u0003\u0015\u0001\u0004\ty\u0002\u0006\u0004\u0002\\\u0005}\u0013\u0011\r\u000b\u0004\u000f\u0006u\u0003\"B\u001f\u0016\u0001\by\u0004bBA\u0006+\u0001\u0007\u0011q\u0004\u0005\b\u0003;)\u0002\u0019AA\u0010)\u0019\t)'!\u001b\u0002lQ\u0019q)a\u001a\t\u000bu2\u00029A \t\u000f\u0005-a\u00031\u0001\u0002 !9\u0011\u0011\b\fA\u0002\u0005mB\u0003CA8\u0003g\n)(a\u001e\u0015\u0007\u001d\u000b\t\bC\u0003>/\u0001\u000fq\bC\u0004\u0002\f]\u0001\r!a\b\t\u000f\u0005er\u00031\u0001\u0002<!9\u0011QD\fA\u0002\u0005}A\u0003CA>\u0003\u007f\n\t)a!\u0015\u0007\u001d\u000bi\bC\u0003>1\u0001\u000fq\bC\u0004\u0002\fa\u0001\r!!\u0004\t\u000f\u0005e\u0002\u00041\u0001\u0002<!9\u0011Q\u0004\rA\u0002\u0005}ACBAD\u0003\u0017\u000bi\tF\u0002H\u0003\u0013CQ!P\rA\u0004}Bq!!\u0013\u001a\u0001\u0004\tY\u0005C\u0004\u0002\u001ee\u0001\r!a\b\u0015\t\u0005E\u0015Q\u0013\u000b\u0004\u000f\u0006M\u0005\"B\u001f\u001b\u0001\by\u0004\"B\u001c\u001b\u0001\u0004I\u0004")
public class CSVWriter
implements Closeable,
Flushable {
    private final Writer writer;
    private final CSVFormat format;
    private final PrintWriter printWriter;
    private final char[] quoteMinimalSpecs;

    public static CSVWriter open(Writer writer, CSVFormat cSVFormat) {
        return CSVWriter$.MODULE$.open(writer, cSVFormat);
    }

    public static CSVWriter open(OutputStream outputStream, String string, CSVFormat cSVFormat) {
        return CSVWriter$.MODULE$.open(outputStream, string, cSVFormat);
    }

    public static CSVWriter open(File file, boolean bl, String string, CSVFormat cSVFormat) {
        return CSVWriter$.MODULE$.open(file, bl, string, cSVFormat);
    }

    public static CSVWriter open(String string, boolean bl, String string2, CSVFormat cSVFormat) {
        return CSVWriter$.MODULE$.open(string, bl, string2, cSVFormat);
    }

    public static CSVWriter open(String string, boolean bl, CSVFormat cSVFormat) {
        return CSVWriter$.MODULE$.open(string, bl, cSVFormat);
    }

    public static CSVWriter open(String string, String string2, CSVFormat cSVFormat) {
        return CSVWriter$.MODULE$.open(string, string2, cSVFormat);
    }

    public static CSVWriter open(String string, CSVFormat cSVFormat) {
        return CSVWriter$.MODULE$.open(string, cSVFormat);
    }

    public static CSVWriter open(OutputStream outputStream, CSVFormat cSVFormat) {
        return CSVWriter$.MODULE$.open(outputStream, cSVFormat);
    }

    public static CSVWriter open(File file, boolean bl, CSVFormat cSVFormat) {
        return CSVWriter$.MODULE$.open(file, bl, cSVFormat);
    }

    public static CSVWriter open(File file, String string, CSVFormat cSVFormat) {
        return CSVWriter$.MODULE$.open(file, string, cSVFormat);
    }

    public static CSVWriter open(File file, CSVFormat cSVFormat) {
        return CSVWriter$.MODULE$.open(file, cSVFormat);
    }

    public Writer writer() {
        return this.writer;
    }

    public CSVFormat format() {
        return this.format;
    }

    @Override
    public void close() {
        this.printWriter.close();
    }

    @Override
    public void flush() {
        this.printWriter.flush();
    }

    public void writeAll(Seq<Seq<Object>> allLines) {
        allLines.foreach((Function1 & Serializable & scala.Serializable)line -> {
            this.writeNext((Seq<Object>)line);
            return BoxedUnit.UNIT;
        });
        if (this.printWriter.checkError()) {
            throw new IOException("Failed to write");
        }
    }

    private void writeNext(Seq<Object> fields) {
        Iterator iterator = fields.iterator();
        boolean hasNext = iterator.hasNext();
        while (hasNext) {
            Object next = iterator.next();
            if (next != null) {
                this.printField$1(next.toString());
            }
            if (!(hasNext = iterator.hasNext())) continue;
            this.printWriter.print(this.format().delimiter());
        }
        this.printWriter.print(this.format().lineTerminator());
    }

    public void writeRow(Seq<Object> fields) {
        this.writeNext(fields);
        if (this.printWriter.checkError()) {
            throw new IOException("Failed to write");
        }
    }

    private final boolean shouldQuote$1(String field, Quoting quoting) {
        boolean bl;
        Quoting quoting2 = quoting;
        if (QUOTE_ALL$.MODULE$.equals(quoting2)) {
            bl = true;
        } else if (QUOTE_MINIMAL$.MODULE$.equals(quoting2)) {
            for (int i = 0; i < field.length(); ++i) {
                char c = StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(field), i);
                for (int j = 0; j < this.quoteMinimalSpecs.length; ++j) {
                    char quoteSpec = this.quoteMinimalSpecs[j];
                    if (quoteSpec != c) continue;
                    return true;
                }
            }
            bl = false;
        } else if (QUOTE_NONE$.MODULE$.equals(quoting2)) {
            bl = false;
        } else if (QUOTE_NONNUMERIC$.MODULE$.equals(quoting2)) {
            boolean foundDot = false;
            for (int i = 0; i < field.length(); ++i) {
                char c = StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(field), i);
                if (c == '.') {
                    if (foundDot) {
                        return true;
                    }
                    foundDot = true;
                    continue;
                }
                if (c >= '0' && c <= '9') continue;
                return true;
            }
            bl = false;
        } else {
            throw new MatchError((Object)quoting2);
        }
        return bl;
    }

    private final void printField$1(String field) {
        block6: {
            block3: {
                if (!this.shouldQuote$1(field, this.format().quoting())) break block3;
                this.printWriter.print(this.format().quoteChar());
                for (int i = 0; i < field.length(); ++i) {
                    char c;
                    block5: {
                        block4: {
                            c = StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(field), i);
                            if (c == this.format().quoteChar()) break block4;
                            Quoting quoting = this.format().quoting();
                            QUOTE_NONE$ qUOTE_NONE$ = QUOTE_NONE$.MODULE$;
                            if ((quoting != null ? !quoting.equals(qUOTE_NONE$) : qUOTE_NONE$ != null) || c != this.format().delimiter()) break block5;
                        }
                        this.printWriter.print(this.format().quoteChar());
                    }
                    this.printWriter.print(c);
                }
                this.printWriter.print(this.format().quoteChar());
                break block6;
            }
            this.printWriter.print(field);
        }
    }

    public CSVWriter(Writer writer, CSVFormat format) {
        this.writer = writer;
        this.format = format;
        this.printWriter = new PrintWriter(writer);
        this.quoteMinimalSpecs = new char[]{'\r', '\n', format.quoteChar(), format.delimiter()};
    }
}

