/*
 * Decompiled with CFR 0.152.
 */
package com.ulisesbocchio.jasyptspringboot.caching;

import com.ulisesbocchio.jasyptspringboot.EncryptablePropertyFilter;
import com.ulisesbocchio.jasyptspringboot.EncryptablePropertyResolver;
import com.ulisesbocchio.jasyptspringboot.EncryptablePropertySource;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.PropertySource;
import org.springframework.util.Assert;

public class CachingDelegateEncryptablePropertySource<T>
extends PropertySource<T>
implements EncryptablePropertySource<T> {
    private static final Logger log = LoggerFactory.getLogger(CachingDelegateEncryptablePropertySource.class);
    private final PropertySource<T> delegate;
    private final EncryptablePropertyResolver resolver;
    private final EncryptablePropertyFilter filter;
    private final Map<String, CachedValue> cache;

    public CachingDelegateEncryptablePropertySource(PropertySource<T> delegate, EncryptablePropertyResolver resolver, EncryptablePropertyFilter filter) {
        super(delegate.getName(), delegate.getSource());
        Assert.notNull(delegate, (String)"PropertySource delegate cannot be null");
        Assert.notNull((Object)resolver, (String)"EncryptablePropertyResolver cannot be null");
        Assert.notNull((Object)filter, (String)"EncryptablePropertyFilter cannot be null");
        this.delegate = delegate;
        this.resolver = resolver;
        this.filter = filter;
        this.cache = new ConcurrentHashMap<String, CachedValue>();
    }

    @Override
    public PropertySource<T> getDelegate() {
        return this.delegate;
    }

    @Override
    public Object getProperty(String name) {
        Object originValue = this.delegate.getProperty(name);
        if (!(originValue instanceof String)) {
            return originValue;
        }
        CachedValue cachedValue = this.cache.get(name);
        if (cachedValue != null && Objects.equals(originValue, cachedValue.originValue)) {
            return cachedValue.resolvedValue;
        }
        if (this.filter.shouldInclude(this.delegate, name)) {
            String originStringValue = (String)originValue;
            String resolved = this.resolver.resolvePropertyValue(originStringValue);
            CachedValue newCachedValue = new CachedValue(originStringValue, resolved);
            if (cachedValue == null) {
                this.cache.putIfAbsent(name, newCachedValue);
            } else {
                this.cache.replace(name, cachedValue, newCachedValue);
            }
            return resolved;
        }
        return originValue;
    }

    @Override
    public void refresh() {
        log.info("Property Source {} refreshed", (Object)this.delegate.getName());
        this.cache.clear();
    }

    private static class CachedValue {
        private final String originValue;
        private final String resolvedValue;

        public CachedValue(String originValue, String resolvedValue) {
            this.originValue = originValue;
            this.resolvedValue = resolvedValue;
        }
    }
}

