/*
 * Decompiled with CFR 0.152.
 */
package com.github.fluent.hibernate.cfg;

import com.github.fluent.hibernate.cfg.HibernateProperties;
import com.github.fluent.hibernate.cfg.IConfigurationBuilder;
import com.github.fluent.hibernate.cfg.ISessionControl;
import com.github.fluent.hibernate.cfg.SessionControlHibernate4;
import com.github.fluent.hibernate.cfg.scanner.EntityScanner;
import com.github.fluent.hibernate.cfg.strategy.StrategyOptions;
import com.github.fluent.hibernate.cfg.strategy.hibernate4.Hibernate4NamingStrategy;
import com.github.fluent.hibernate.internal.util.InternalUtils;
import com.github.fluent.hibernate.internal.util.reflection.ReflectionUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.Properties;
import org.hibernate.SessionFactory;
import org.hibernate.boot.registry.StandardServiceRegistryBuilder;
import org.hibernate.cfg.Configuration;
import org.hibernate.cfg.Environment;
import org.hibernate.service.ServiceRegistry;

class ConfigurationBuilderHibernate4
implements IConfigurationBuilder {
    private static final String HIBERNATE4_NAMING_STRATEGY_INTERFACE = "org.hibernate.cfg.NamingStrategy";
    private StandardServiceRegistryBuilder registryBuilder = new StandardServiceRegistryBuilder();
    private final Configuration result = new Configuration();

    ConfigurationBuilderHibernate4() {
    }

    @Override
    public void configure(String hibernateCfgXml) {
        if (hibernateCfgXml == null) {
            this.result.configure();
        } else {
            this.result.configure(hibernateCfgXml);
        }
    }

    @Override
    public void addHibernateProperties(HibernateProperties options) {
        this.addProperties(options.getOptionsAsProperties());
    }

    @Override
    public SessionFactory buildSessionFactory() {
        return this.result.buildSessionFactory((ServiceRegistry)this.registryBuilder.applySettings((Map)this.result.getProperties()).build());
    }

    @Override
    public void addPropertiesFromClassPath(String classPathResourcePath) {
        this.registryBuilder.loadProperties(classPathResourcePath);
    }

    @Override
    public void addPropertiesFromFile(File propertiesFilePath) {
        try {
            this.addProperties(this.loadProperties(new FileInputStream(propertiesFilePath)));
        }
        catch (Exception ex) {
            throw InternalUtils.toRuntimeException(ex);
        }
    }

    private Properties loadProperties(InputStream stream) {
        Properties result = new Properties();
        try {
            result.load(stream);
            Properties properties = result;
            return properties;
        }
        catch (Exception ex) {
            throw InternalUtils.toRuntimeException(ex);
        }
        finally {
            InternalUtils.closeQuietly(stream);
        }
    }

    private void addProperties(Properties properties) {
        this.registryBuilder.applySettings((Map)properties);
    }

    @Override
    public void addAnnotatedClasses(Class<?>[] annotatedClasses) {
        if (annotatedClasses == null) {
            return;
        }
        for (Class<?> annotatedClass : annotatedClasses) {
            this.result.addAnnotatedClass(annotatedClass);
        }
    }

    @Override
    public void addPackagesToScan(String[] packagesToScan) {
        EntityScanner.scanPackages(packagesToScan).addTo(this.result);
    }

    @Override
    public void useNamingStrategy(StrategyOptions options) {
        if (options.isAutodetectMaxLength()) {
            options.setMaxLength(this.detectMaxLength(Environment.getProperties().getProperty("hibernate.dialect")));
        }
        this.useNamingStrategy((Object)new Hibernate4NamingStrategy(options));
    }

    @Override
    public void useNamingStrategy(Object strategy) {
        Class<?> namingStartegyInterface = InternalUtils.ClassUtils.classForNameFromContext(HIBERNATE4_NAMING_STRATEGY_INTERFACE);
        if (strategy != null && !namingStartegyInterface.isInstance(strategy)) {
            InternalUtils.Asserts.fail(String.format("Incorrect naming strategy `%s`. It should be an instance of NamingStrategy", strategy.getClass().getSimpleName()));
        }
        try {
            ReflectionUtils.invoke(this.result, ConfigurationBuilderHibernate4.getSetNamingStrategyMethod(namingStartegyInterface), strategy);
        }
        catch (Exception ex) {
            throw InternalUtils.toRuntimeException("Can't invoke setNamingStrategy() method by reflection", ex);
        }
    }

    private static Method getSetNamingStrategyMethod(Class<?> namingStartegyInterface) {
        try {
            return ReflectionUtils.extractMethod(Configuration.class, "setNamingStrategy", namingStartegyInterface);
        }
        catch (Exception ex) {
            throw InternalUtils.toRuntimeException("Can't get setNamingStrategy() method from Configuration by a reflection.", ex);
        }
    }

    private int detectMaxLength(String dialect) {
        InternalUtils.Asserts.isTrue(!InternalUtils.StringUtils.isEmpty(dialect), String.format("Can't autodetect the max length. Property %s is not set", "hibernate.dialect"));
        String dialectClass = InternalUtils.ClassUtils.getShortName(dialect);
        if (dialectClass.contains("H2Dialect")) {
            return 0;
        }
        if (dialectClass.contains("MySQL")) {
            return 64;
        }
        if (dialectClass.contains("Oracle")) {
            return 30;
        }
        if (dialectClass.contains("PostgreSQL")) {
            return 63;
        }
        InternalUtils.Asserts.fail("Can't autodetect the max length. Specify it with StrategyOptions.setMaxLength()");
        return 0;
    }

    @Override
    public ISessionControl createSessionControl() {
        return new SessionControlHibernate4();
    }
}

