/*
 * Decompiled with CFR 0.152.
 */
package com.github.fluent.hibernate.cfg;

import com.github.fluent.hibernate.cfg.HibernateProperties;
import com.github.fluent.hibernate.cfg.IConfigurationBuilder;
import com.github.fluent.hibernate.cfg.ISessionControl;
import com.github.fluent.hibernate.cfg.SessionControlHibernate5;
import com.github.fluent.hibernate.cfg.scanner.EntityScanner;
import com.github.fluent.hibernate.cfg.strategy.StrategyOptions;
import com.github.fluent.hibernate.cfg.strategy.hibernate5.Hibernate5NamingStrategy;
import com.github.fluent.hibernate.internal.util.InternalUtils;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.hibernate.SessionFactory;
import org.hibernate.boot.MetadataBuilder;
import org.hibernate.boot.MetadataSources;
import org.hibernate.boot.model.naming.ImplicitNamingStrategy;
import org.hibernate.boot.model.naming.PhysicalNamingStrategy;
import org.hibernate.boot.registry.StandardServiceRegistryBuilder;
import org.hibernate.cfg.Environment;
import org.hibernate.service.ServiceRegistry;

class ConfigurationBuilderHibernate5
implements IConfigurationBuilder {
    private StandardServiceRegistryBuilder registryBuilder = new StandardServiceRegistryBuilder();
    private MetadataSources metadataSourcesCached;
    private PhysicalNamingStrategy physicalNamingStrategy;
    private ImplicitNamingStrategy implicitNamingStartegy;

    ConfigurationBuilderHibernate5() {
    }

    @Override
    public void configure(String hibernateCfgXml) {
        if (hibernateCfgXml == null) {
            this.registryBuilder.configure();
        } else {
            this.registryBuilder.configure(hibernateCfgXml);
        }
    }

    @Override
    public void addHibernateProperties(HibernateProperties options) {
        this.registryBuilder.applySettings((Map)options.getOptionsAsProperties());
    }

    @Override
    public SessionFactory buildSessionFactory() {
        MetadataBuilder metadataBuilder = this.getMetadataSources().getMetadataBuilder();
        if (this.physicalNamingStrategy != null) {
            metadataBuilder.applyPhysicalNamingStrategy(this.physicalNamingStrategy);
        }
        if (this.implicitNamingStartegy != null) {
            metadataBuilder.applyImplicitNamingStrategy(this.implicitNamingStartegy);
        }
        return metadataBuilder.build().buildSessionFactory();
    }

    @Override
    public void addPropertiesFromClassPath(String classPathResourcePath) {
        this.registryBuilder.loadProperties(classPathResourcePath);
    }

    @Override
    public void addPropertiesFromFile(File propertiesFilePath) {
        this.registryBuilder.loadProperties(propertiesFilePath);
    }

    @Override
    public void addAnnotatedClasses(Class<?>[] annotatedClasses) {
        this.addAnnotatedClassesToMetadata(Arrays.asList(annotatedClasses));
    }

    @Override
    public void addPackagesToScan(String[] packagesToScan) {
        this.addAnnotatedClassesToMetadata(EntityScanner.scanPackages(packagesToScan).result());
    }

    private void addAnnotatedClassesToMetadata(List<Class<?>> annotatedClasses) {
        MetadataSources metadataSources = this.getMetadataSources();
        for (Class<?> annotatedClass : annotatedClasses) {
            metadataSources.addAnnotatedClass(annotatedClass);
        }
    }

    @Override
    public void useNamingStrategy(StrategyOptions options) {
        if (options.isAutodetectMaxLength()) {
            options.setMaxLength(this.detectMaxLength(Environment.getProperties().getProperty("hibernate.dialect")));
        }
        this.useNamingStrategy((Object)new Hibernate5NamingStrategy(options));
    }

    @Override
    public void useNamingStrategy(Object strategy) {
        if (strategy == null) {
            this.implicitNamingStartegy = null;
            this.physicalNamingStrategy = null;
            return;
        }
        if (strategy instanceof ImplicitNamingStrategy) {
            this.implicitNamingStartegy = (ImplicitNamingStrategy)strategy;
            return;
        }
        if (strategy instanceof PhysicalNamingStrategy) {
            this.physicalNamingStrategy = (PhysicalNamingStrategy)strategy;
            return;
        }
        InternalUtils.Asserts.fail(String.format("Incorrect naming strategy `%s`. It should be an instance of ImplicitNamingStrategy or PhysicalNamingStrategy", strategy.getClass().getSimpleName()));
    }

    private int detectMaxLength(String dialect) {
        InternalUtils.Asserts.isTrue(!InternalUtils.StringUtils.isEmpty(dialect), String.format("Can't autodetect a max length. Property %s is not set", "hibernate.dialect"));
        String dialectClass = InternalUtils.ClassUtils.getShortName(dialect);
        if (dialectClass.contains("H2Dialect")) {
            return 0;
        }
        if (dialectClass.contains("MySQL")) {
            return 64;
        }
        if (dialectClass.contains("Oracle")) {
            return 30;
        }
        if (dialectClass.contains("PostgreSQL")) {
            return 63;
        }
        InternalUtils.Asserts.fail("Can't autodetect a max length. Specify it with StrategyOptions.setMaxLength()");
        return 0;
    }

    private MetadataSources getMetadataSources() {
        if (this.metadataSourcesCached == null) {
            this.metadataSourcesCached = new MetadataSources((ServiceRegistry)this.registryBuilder.build());
        }
        return this.metadataSourcesCached;
    }

    @Override
    public ISessionControl createSessionControl() {
        return new SessionControlHibernate5();
    }
}

