/*
 * Decompiled with CFR 0.152.
 */
package com.github.fluent.hibernate.cfg;

import com.github.fluent.hibernate.cfg.ConfigurationBuilderHibernate4;
import com.github.fluent.hibernate.cfg.ConfigurationBuilderHibernate5;
import com.github.fluent.hibernate.cfg.HibernateProperties;
import com.github.fluent.hibernate.cfg.HibernateSessionFactory;
import com.github.fluent.hibernate.cfg.IConfigurationBuilder;
import com.github.fluent.hibernate.cfg.SessionControlHibernate4;
import com.github.fluent.hibernate.cfg.SessionControlHibernate5;
import com.github.fluent.hibernate.cfg.strategy.StrategyOptions;
import com.github.fluent.hibernate.internal.util.InternalUtils;
import java.io.File;
import org.hibernate.SessionFactory;

public class FluentFactoryBuilder {
    private final IConfigurationBuilder configurationBuilder;
    private boolean useHibernateCfgXml = true;
    private String hibernateCfgXmlPath;
    private Class<?>[] annotatedClasses;
    private String[] packagesToScan;
    private boolean hibernate4Used = InternalUtils.HibernateUtils.isHibernate4Used();

    public FluentFactoryBuilder() {
        this.configurationBuilder = this.hibernate4Used ? new ConfigurationBuilderHibernate4() : new ConfigurationBuilderHibernate5();
    }

    public FluentFactoryBuilder hibernateCfgXml(String hibernateCfgXmlPath) {
        this.hibernateCfgXmlPath = hibernateCfgXmlPath;
        return this;
    }

    public FluentFactoryBuilder dontUseHibernateCfgXml() {
        this.useHibernateCfgXml = false;
        return this;
    }

    public FluentFactoryBuilder hibernateProperties(HibernateProperties options) {
        this.configurationBuilder.addHibernateProperties(options);
        return this;
    }

    public FluentFactoryBuilder hibernatePropertiesFromFile(File propertiesFilePath) {
        this.configurationBuilder.addPropertiesFromFile(propertiesFilePath);
        return this;
    }

    public FluentFactoryBuilder hibernatePropertiesFromClassPathResource(String classPathResourcePath) {
        this.configurationBuilder.addPropertiesFromClassPath(classPathResourcePath);
        return this;
    }

    public FluentFactoryBuilder annotatedClasses(Class<?> ... annotatedClasses) {
        this.annotatedClasses = annotatedClasses;
        return this;
    }

    public FluentFactoryBuilder scanPackages(String ... packagesToScan) {
        this.packagesToScan = packagesToScan;
        return this;
    }

    public FluentFactoryBuilder useNamingStrategy() {
        this.useNamingStrategy(new StrategyOptions());
        return this;
    }

    public FluentFactoryBuilder useNamingStrategy(StrategyOptions options) {
        this.configurationBuilder.useNamingStrategy(options);
        return this;
    }

    public FluentFactoryBuilder useNamingStrategy(Object strategy) {
        this.configurationBuilder.useNamingStrategy(strategy);
        return this;
    }

    public FluentFactoryBuilder h2ConfigForTests() {
        return this.configForTests().hibernateProperties(HibernateProperties.forH2CreateDrop());
    }

    public FluentFactoryBuilder configForTests() {
        return this.dontUseHibernateCfgXml().useNamingStrategy();
    }

    public FluentFactoryBuilder showSql() {
        return this.hibernateProperties(HibernateProperties.create().showSql(true).formatSql(true).useSqlComments(true));
    }

    public void build() {
        if (this.useHibernateCfgXml) {
            this.configurationBuilder.configure(this.hibernateCfgXmlPath);
        }
        if (this.annotatedClasses != null) {
            this.configurationBuilder.addAnnotatedClasses(this.annotatedClasses);
        }
        if (this.packagesToScan != null) {
            this.configurationBuilder.addPackagesToScan(this.packagesToScan);
        }
        FluentFactoryBuilder.configureFromExistingSessionFactory(this.configurationBuilder.buildSessionFactory(), this.hibernate4Used);
    }

    public void close() {
        HibernateSessionFactory.closeSessionFactory();
    }

    static void configureFromExistingSessionFactory(SessionFactory sessionFactory) {
        FluentFactoryBuilder.configureFromExistingSessionFactory(sessionFactory, InternalUtils.HibernateUtils.isHibernate4Used());
    }

    private static void configureFromExistingSessionFactory(SessionFactory sessionFactory, boolean hibernate4Used) {
        HibernateSessionFactory.setExistingSessionFactory(sessionFactory, hibernate4Used ? new SessionControlHibernate4() : new SessionControlHibernate5());
    }
}

