/*
 * Decompiled with CFR 0.152.
 */
package com.github.fluent.hibernate.cfg;

import java.util.Properties;
import org.hibernate.dialect.H2Dialect;

public final class HibernateProperties {
    private final Properties options = new Properties();

    private HibernateProperties() {
    }

    public static HibernateProperties forH2CreateDrop() {
        return HibernateProperties.forH2().hbm2DllAuto(Hbm2DllAuto.CREATE_DROP);
    }

    public static HibernateProperties forH2() {
        return HibernateProperties.create().dialect(H2Dialect.class).driverClass("org.h2.Driver").userName("sa").password("").connectionUrl("jdbc:h2:mem:di;MODE=ORACLE");
    }

    public static HibernateProperties create() {
        return new HibernateProperties();
    }

    public HibernateProperties connectionUrl(String connectionUrl) {
        this.options.put("hibernate.connection.url", connectionUrl);
        return this;
    }

    public HibernateProperties userName(String userName) {
        this.options.put("hibernate.connection.username", userName);
        return this;
    }

    public HibernateProperties password(String password) {
        this.options.put("hibernate.connection.password", password);
        return this;
    }

    public HibernateProperties driverClass(String driverClass) {
        this.options.put("hibernate.connection.driver_class", driverClass);
        return this;
    }

    public HibernateProperties dialect(String dialectClass) {
        this.options.put("hibernate.dialect", dialectClass);
        return this;
    }

    public HibernateProperties dialect(Class<?> dialectClass) {
        this.options.put("hibernate.dialect", dialectClass.getName());
        return this;
    }

    public HibernateProperties hbm2DllAuto(Hbm2DllAuto hbm2DllAuto) {
        this.options.put("hibernate.hbm2ddl.auto", hbm2DllAuto.getAsString());
        return this;
    }

    public HibernateProperties showSql(boolean showSql) {
        this.options.put("hibernate.show_sql", Boolean.toString(showSql));
        return this;
    }

    public HibernateProperties useSqlComments(boolean useSqlComments) {
        this.options.put("hibernate.use_sql_comments", Boolean.toString(useSqlComments));
        return this;
    }

    public HibernateProperties formatSql(boolean formatSql) {
        this.options.put("hibernate.format_sql", Boolean.toString(formatSql));
        return this;
    }

    public HibernateProperties property(String name, String value) {
        this.options.put(name, value);
        return this;
    }

    Properties getOptionsAsProperties() {
        return this.options;
    }

    public static enum Hbm2DllAuto {
        CREATE("create"),
        CREATE_DROP("create-drop"),
        UPDATE("update"),
        VALIDATE("validate"),
        NONE("none");

        private String asString;

        private Hbm2DllAuto(String asString) {
            this.asString = asString;
        }

        public String getAsString() {
            return this.asString;
        }
    }
}

