/*
 * Decompiled with CFR 0.152.
 */
package com.github.fluent.hibernate.cfg.scanner;

import com.github.fluent.hibernate.cfg.scanner.ClassFileBuffer;
import com.github.fluent.hibernate.cfg.scanner.ConstantPool;
import com.github.fluent.hibernate.cfg.scanner.ResourceUtils;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;

public class AnnotationChecker {
    private static final int HEAD = -889275714;
    private static final int BYTE = 66;
    private static final int CHAR = 67;
    private static final int DOUBLE = 68;
    private static final int FLOAT = 70;
    private static final int INT = 73;
    private static final int LONG = 74;
    private static final int SHORT = 83;
    private static final int BOOLEAN = 90;
    private static final int STRING = 115;
    private static final int ENUM = 101;
    private static final int CLASS = 99;
    private static final int ANNOTATION = 64;
    private static final int ARRAY = 91;
    private final ClassFileBuffer buffer = new ClassFileBuffer();
    private final ConstantPool constantPool = new ConstantPool();
    private final String annotationDescriptor;

    public AnnotationChecker(Class<? extends Annotation> annotation) {
        this.annotationDescriptor = ResourceUtils.toDescriptor(annotation);
    }

    public boolean hasAnnotation(InputStream classStream) throws IOException {
        if (classStream == null) {
            return false;
        }
        try {
            this.buffer.readFrom(classStream);
            boolean bl = this.hasCafebabe() ? this.detect() : false;
            return bl;
        }
        finally {
            ResourceUtils.closeQuietly(classStream);
        }
    }

    private boolean hasCafebabe() throws IOException {
        return this.buffer.size() > 4 && this.buffer.readInt() == -889275714;
    }

    private boolean detect() throws IOException {
        this.readVersion();
        this.readConstantPool();
        this.readAccessFlags();
        this.readThisClass();
        this.readSuperClass();
        this.readInterfaces();
        this.readFields();
        this.readMethods();
        return this.checkTypeAnnotations();
    }

    private void readVersion() throws IOException {
        this.buffer.skipBytes(4);
    }

    private void readConstantPool() throws IOException {
        this.constantPool.readEntries(this.buffer);
    }

    private void readAccessFlags() throws IOException {
        this.buffer.skipUnsignedShort();
    }

    private void readThisClass() throws IOException {
        this.buffer.skipUnsignedShort();
    }

    private void readSuperClass() throws IOException {
        this.buffer.skipUnsignedShort();
    }

    private void readInterfaces() throws IOException {
        int count = this.buffer.readUnsignedShort();
        this.buffer.skipBytes(count * 2);
    }

    private void readFields() throws IOException {
        this.readInfoStruct();
    }

    private void readMethods() throws IOException {
        this.readInfoStruct();
    }

    private void readInfoStruct() throws IOException {
        int count = this.buffer.readUnsignedShort();
        for (int i = 0; i < count; ++i) {
            this.readAccessFlags();
            this.readNameIndex();
            this.readDescriptorIndex();
            this.readAttributes();
        }
    }

    private void readAttributes() throws IOException {
        int count = this.buffer.readUnsignedShort();
        for (int i = 0; i < count; ++i) {
            this.readNameIndex();
            int length = this.buffer.readInt();
            this.buffer.skipBytes(length);
        }
    }

    private void readNameIndex() throws IOException {
        this.buffer.skipUnsignedShort();
    }

    private void readDescriptorIndex() throws IOException {
        this.buffer.skipUnsignedShort();
    }

    private boolean checkTypeAnnotations() throws IOException {
        int count = this.buffer.readUnsignedShort();
        for (int i = 0; i < count; ++i) {
            String name = this.resolveUtf8();
            int length = this.buffer.readInt();
            if ("RuntimeVisibleAnnotations".equals(name) || "RuntimeInvisibleAnnotations".equals(name)) {
                if (!this.checkTypeAnnotationsHelper()) continue;
                return true;
            }
            this.buffer.skipBytes(length);
        }
        return false;
    }

    private boolean checkTypeAnnotationsHelper() throws IOException {
        int count = this.buffer.readUnsignedShort();
        for (int i = 0; i < count; ++i) {
            String descriptor = this.readAnnotation();
            if (!this.annotationDescriptor.equals(descriptor)) continue;
            return true;
        }
        return false;
    }

    private String readAnnotation() throws IOException {
        String rawTypeName = this.resolveUtf8();
        int count = this.buffer.readUnsignedShort();
        for (int i = 0; i < count; ++i) {
            this.buffer.skipUnsignedShort();
            this.readAnnotationElementValue();
        }
        return rawTypeName;
    }

    private void readAnnotationElementValue() throws IOException {
        int tag = this.buffer.readUnsignedByte();
        switch (tag) {
            case 66: 
            case 67: 
            case 68: 
            case 70: 
            case 73: 
            case 74: 
            case 83: 
            case 90: 
            case 115: {
                this.buffer.skipUnsignedShort();
                break;
            }
            case 101: {
                this.buffer.skipBytes(4);
                break;
            }
            case 99: {
                this.buffer.skipUnsignedShort();
                break;
            }
            case 64: {
                this.readAnnotation();
                break;
            }
            case 91: {
                int count = this.buffer.readUnsignedShort();
                for (int i = 0; i < count; ++i) {
                    this.readAnnotationElementValue();
                }
                break;
            }
            default: {
                throw new ClassFormatError("Not a valid annotation element type tag: 0x" + Integer.toHexString(tag));
            }
        }
    }

    private String resolveUtf8() throws IOException {
        int index = this.buffer.readUnsignedShort();
        return this.constantPool.getConstant(index);
    }
}

