/*
 * Decompiled with CFR 0.152.
 */
package com.github.fluent.hibernate.cfg.scanner;

import com.github.fluent.hibernate.cfg.scanner.ClassLoaderUtils;
import com.github.fluent.hibernate.cfg.scanner.ResourceUtils;
import com.github.fluent.hibernate.cfg.scanner.UrlExtractor;
import com.github.fluent.hibernate.cfg.scanner.UrlWrapper;
import com.github.fluent.hibernate.internal.util.InternalUtils;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;

public class ClasspathScanner {
    private final Set<UrlWrapper> scanned = InternalUtils.CollectionUtils.newHashSet();
    private final Set<String> scannedResources = new HashSet<String>();
    private List<String> resourcesToScan;
    private List<ClassLoader> loaders;
    private final IResourceAcceptor acceptor;
    private boolean scanAllPackages;

    public ClasspathScanner(IResourceAcceptor acceptor) {
        this.acceptor = acceptor;
    }

    public void setPackagesToScan(List<String> packagesToScan) {
        this.resourcesToScan = ResourceUtils.packagesAsResourcePath(packagesToScan);
    }

    public void allPackagesToScan() {
        this.setPackagesToScan(Collections.<String>emptyList());
        this.scanAllPackages = true;
    }

    public void setLoaders(List<ClassLoader> loaders) {
        this.loaders = loaders;
    }

    public void scan() throws Exception {
        for (UrlWrapper url : this.getUrls()) {
            this.scan(url);
        }
    }

    private Set<UrlWrapper> getUrls() {
        return UrlExtractor.createForResources(this.resourcesToScan).usingLoaders(InternalUtils.CollectionUtils.isEmpty(this.loaders) ? ClassLoaderUtils.defaultClassLoaders() : this.loaders).extract();
    }

    private void scan(UrlWrapper url) throws Exception {
        if (!this.scanned.add(url)) {
            return;
        }
        if (url.isFile()) {
            this.scanFile(url);
        } else {
            this.scanJar(url);
        }
    }

    private void scanFile(UrlWrapper url) throws Exception {
        File file = url.getFile();
        if (!file.exists()) {
            return;
        }
        if (file.isDirectory()) {
            this.scanDirectory(url.getLoader(), file);
        } else {
            this.scanJar(url);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scanJar(UrlWrapper url) throws Exception {
        JarFile jarFile = url.getJarFile();
        if (jarFile == null) {
            return;
        }
        try {
            for (UrlWrapper urlFromManifest : ClasspathScanner.getClassPathFromManifest(jarFile, url.getLoader())) {
                this.scan(urlFromManifest);
            }
            this.scanJarFile(jarFile, url.getLoader());
        }
        finally {
            ResourceUtils.closeQuietly(jarFile);
        }
    }

    private void scanJarFile(JarFile file, ClassLoader loader) throws Exception {
        Enumeration<JarEntry> entries = file.entries();
        while (entries.hasMoreElements()) {
            JarEntry entry = entries.nextElement();
            if (entry.isDirectory() || entry.getName().equals("META-INF/MANIFEST.MF")) continue;
            this.addResource(entry.getName(), loader);
        }
    }

    private void scanDirectory(ClassLoader loader, File directory) throws Exception {
        this.scanDirectory(directory, loader, "");
    }

    private void scanDirectory(File directory, ClassLoader classloader, String packagePrefix) throws Exception {
        File[] files = directory.listFiles();
        if (files == null) {
            return;
        }
        for (File f : files) {
            String name = f.getName();
            if (f.isDirectory()) {
                this.scanDirectory(f, classloader, packagePrefix + name + "/");
                continue;
            }
            String resourceName = packagePrefix + name;
            if (resourceName.equals("META-INF/MANIFEST.MF")) continue;
            this.addResource(resourceName, classloader);
        }
    }

    private static Set<UrlWrapper> getClassPathFromManifest(JarFile jarFile, ClassLoader loader) throws IOException {
        Manifest manifest = jarFile.getManifest();
        if (manifest == null) {
            return Collections.emptySet();
        }
        HashSet<UrlWrapper> result = InternalUtils.CollectionUtils.newHashSet();
        String classpathAttribute = manifest.getMainAttributes().getValue(Attributes.Name.CLASS_PATH.toString());
        if (classpathAttribute == null) {
            return result;
        }
        for (String path : InternalUtils.StringUtils.splitBySpace(classpathAttribute)) {
            URL url;
            try {
                url = ClasspathScanner.getClassPathEntry(jarFile, path);
            }
            catch (MalformedURLException e) {
                continue;
            }
            result.add(new UrlWrapper(url, loader));
        }
        return result;
    }

    private void addResource(String resource, ClassLoader loader) throws Exception {
        if (!this.scannedResources.add(resource)) {
            return;
        }
        if (this.canAddToResult(resource)) {
            this.acceptor.accept(resource, loader);
        }
    }

    private boolean canAddToResult(String resource) throws IOException {
        if (this.scanAllPackages) {
            return true;
        }
        for (String resourceToScan : this.resourcesToScan) {
            if (!resource.startsWith(resourceToScan)) continue;
            return true;
        }
        return false;
    }

    private static URL getClassPathEntry(JarFile jarFile, String path) throws MalformedURLException {
        return new URL(new File(jarFile.getName()).toURI().toURL(), path);
    }

    public static interface IResourceAcceptor {
        public void accept(String var1, ClassLoader var2) throws Exception;
    }
}

