/*
 * Decompiled with CFR 0.152.
 */
package com.github.fluent.hibernate.cfg.scanner;

import java.io.DataInput;
import java.io.IOException;

class ConstantPool {
    private static final int CP_UTF8 = 1;
    private static final int CP_INTEGER = 3;
    private static final int CP_FLOAT = 4;
    private static final int CP_LONG = 5;
    private static final int CP_DOUBLE = 6;
    private static final int CP_CLASS = 7;
    private static final int CP_STRING = 8;
    private static final int CP_REF_FIELD = 9;
    private static final int CP_REF_METHOD = 10;
    private static final int CP_REF_INTERFACE = 11;
    private static final int CP_NAME_AND_TYPE = 12;
    private static final int CP_METHOD_HANDLE = 15;
    private static final int CP_METHOD_TYPE = 16;
    private static final int CP_INVOKE_DYNAMIC = 18;
    private static final int BUFFER_SIZE = 8192;
    private Object[] buffer = new Object[8192];
    private DataInput di;

    ConstantPool() {
    }

    public void readEntries(DataInput di) throws IOException {
        this.di = di;
        int count = di.readUnsignedShort();
        this.allocateBuffer(count);
        for (int i = 1; i < count; ++i) {
            if (!this.readConstantPoolEntry(i)) continue;
            ++i;
        }
    }

    private void allocateBuffer(int size) {
        if (this.buffer.length < size) {
            this.buffer = new Object[size];
        }
    }

    private boolean readConstantPoolEntry(int index) throws IOException {
        int tag = this.di.readUnsignedByte();
        switch (tag) {
            case 16: {
                this.di.skipBytes(2);
                return false;
            }
            case 15: {
                this.di.skipBytes(3);
                return false;
            }
            case 3: 
            case 4: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 18: {
                this.di.skipBytes(4);
                return false;
            }
            case 5: 
            case 6: {
                this.di.skipBytes(8);
                return true;
            }
            case 1: {
                this.buffer[index] = this.di.readUTF();
                return false;
            }
            case 7: 
            case 8: {
                this.buffer[index] = this.di.readUnsignedShort();
                return false;
            }
        }
        throw new ClassFormatError("Unkown tag value for constant pool entry: " + tag);
    }

    public String getConstant(int index) {
        Object value = this.buffer[index];
        return (String)(value instanceof Integer ? this.buffer[(Integer)value] : value);
    }
}

