/*
 * Decompiled with CFR 0.152.
 */
package com.github.fluent.hibernate.cfg.scanner;

import com.github.fluent.hibernate.internal.util.InternalUtils;
import java.io.Closeable;
import java.lang.annotation.Annotation;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipFile;

final class ResourceUtils {
    private static final char PACKAGE_SEPARATOR = '.';
    private static final char PATH_SEPARATOR = '/';
    private static final String PATH_SEPARATOR_AS_STRING = String.valueOf('/');
    private static final String CLASS_FILE_NAME_EXTENSION = ".class";
    private static final String URL_PROTOCOL_FILE = "file";

    private ResourceUtils() {
    }

    public static List<String> packagesAsResourcePath(List<String> packageNames) {
        ArrayList<String> result = InternalUtils.CollectionUtils.newArrayListWithCapacity(InternalUtils.CollectionUtils.size(packageNames));
        for (String packageName : packageNames) {
            result.add(ResourceUtils.packageAsResourcePath(packageName));
        }
        return result;
    }

    public static String packageAsResourcePath(String packageName) {
        return packageName.replace('.', '/');
    }

    public static String resourcePathFromRoot(String resourcePath) {
        return resourcePath.startsWith(PATH_SEPARATOR_AS_STRING) ? resourcePath : '/' + resourcePath;
    }

    public static String getClassNameFromPath(String classFilePath) {
        int classNameEnd = classFilePath.length() - CLASS_FILE_NAME_EXTENSION.length();
        return classFilePath.substring(0, classNameEnd).replace('/', '.');
    }

    public static String classAsResource(Class<?> clazz) {
        return clazz.getName().replace('.', '/') + CLASS_FILE_NAME_EXTENSION;
    }

    public static String toDescriptor(Class<? extends Annotation> annotation) {
        return "L" + ResourceUtils.packageAsResourcePath(annotation.getName()) + ";";
    }

    public static boolean isFile(URL url) {
        return url != null && url.getProtocol().equals(URL_PROTOCOL_FILE);
    }

    public static boolean closeQuietly(Closeable closeable) {
        try {
            if (closeable != null) {
                closeable.close();
            }
        }
        catch (Exception ignored) {
            return false;
        }
        return true;
    }

    public static boolean closeQuietly(ZipFile zipFile) {
        try {
            if (zipFile != null) {
                zipFile.close();
            }
        }
        catch (Exception ignored) {
            return false;
        }
        return true;
    }

    public static boolean hasClassExtension(String path) {
        return path != null && path.endsWith(CLASS_FILE_NAME_EXTENSION);
    }
}

