/*
 * Decompiled with CFR 0.152.
 */
package com.github.fluent.hibernate.cfg.scanner;

import com.github.fluent.hibernate.cfg.scanner.UrlWrapper;
import com.github.fluent.hibernate.internal.util.InternalUtils;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Enumeration;
import java.util.List;
import java.util.Set;

final class UrlExtractor {
    private final List<String> resources;
    private final Set<UrlWrapper> result = InternalUtils.CollectionUtils.newHashSet();
    private List<ClassLoader> loaders;

    private UrlExtractor(List<String> resources) {
        this.resources = InternalUtils.CollectionUtils.correctToEmpty(resources);
    }

    public static UrlExtractor createForResources(List<String> resources) {
        return new UrlExtractor(resources);
    }

    public UrlExtractor usingLoaders(List<ClassLoader> loaders) {
        this.loaders = InternalUtils.CollectionUtils.correctToEmpty(loaders);
        return this;
    }

    public Set<UrlWrapper> extract() {
        for (String resource : this.resources) {
            this.forResource(resource);
        }
        if (this.result.isEmpty()) {
            for (ClassLoader loader : this.loaders) {
                this.forClassLoader(loader);
            }
        }
        return this.result;
    }

    private void forResource(String resourceToScan) {
        for (ClassLoader loader : this.loaders) {
            try {
                this.getUrls(resourceToScan, loader);
            }
            catch (IOException iOException) {}
        }
    }

    private void getUrls(String resourceName, ClassLoader loader) throws IOException {
        Enumeration<URL> urls = loader.getResources(resourceName);
        while (urls.hasMoreElements()) {
            URL url = urls.nextElement();
            int index = url.toExternalForm().lastIndexOf(resourceName);
            this.addUrl(index == -1 ? url : new URL(url.toExternalForm().substring(0, index)), loader);
        }
    }

    private void forClassLoader(ClassLoader loader) {
        if (loader == null) {
            return;
        }
        this.forClassLoader(loader.getParent());
        if (loader instanceof URLClassLoader) {
            URL[] urls = ((URLClassLoader)loader).getURLs();
            this.addUrls(urls, loader);
        }
    }

    private void addUrls(URL[] urls, ClassLoader loader) {
        if (urls == null) {
            return;
        }
        for (URL url : urls) {
            this.addUrl(url, loader);
        }
    }

    private void addUrl(URL url, ClassLoader loader) {
        UrlWrapper urlWrapper = new UrlWrapper(url, loader);
        if (!this.result.contains(urlWrapper)) {
            this.result.add(urlWrapper);
        }
    }
}

