/*
 * Decompiled with CFR 0.152.
 */
package com.github.fluent.hibernate.cfg.scanner;

import com.github.fluent.hibernate.cfg.scanner.ResourceUtils;
import java.io.File;
import java.io.IOException;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.jar.JarFile;
import sun.net.www.protocol.file.FileURLConnection;

class UrlWrapper {
    private final URL url;
    private final String externalForm;
    private final ClassLoader loader;

    public UrlWrapper(URL url, ClassLoader loader) {
        this.url = url;
        this.loader = loader;
        this.externalForm = url.toExternalForm();
    }

    public URL getUrl() {
        return this.url;
    }

    public boolean isFile() {
        return ResourceUtils.isFile(this.url);
    }

    public File getFile() {
        return new File(this.url.getFile());
    }

    public JarFile getJarFile() throws IOException {
        URLConnection urlConnection = this.url.openConnection();
        if (urlConnection instanceof JarURLConnection) {
            return ((JarURLConnection)urlConnection).getJarFile();
        }
        if (urlConnection instanceof FileURLConnection) {
            return UrlWrapper.createJarFile(this.getFile());
        }
        return null;
    }

    private static JarFile createJarFile(File file) {
        try {
            return new JarFile(file);
        }
        catch (IOException ignore) {
            return null;
        }
    }

    public ClassLoader getLoader() {
        return this.loader;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        return obj instanceof UrlWrapper ? this.externalForm.equals(((UrlWrapper)obj).externalForm) : false;
    }

    public int hashCode() {
        return this.externalForm.hashCode();
    }

    public String toString() {
        return this.url.toString();
    }

    public String getExternalForm() {
        return this.externalForm;
    }
}

