/*
 * Decompiled with CFR 0.152.
 */
package com.github.fluent.hibernate.cfg.strategy;

import com.github.fluent.hibernate.cfg.strategy.NameShorter;
import com.github.fluent.hibernate.cfg.strategy.NamingStrategyUtils;
import com.github.fluent.hibernate.cfg.strategy.StrategyOptions;
import com.github.fluent.hibernate.internal.util.InternalUtils;

public class HibernateNamingStrategy {
    private StrategyOptions options;

    public HibernateNamingStrategy(StrategyOptions options) {
        this.options = options;
    }

    public StrategyOptions getOptions() {
        return this.options;
    }

    public void setOptions(StrategyOptions options) {
        this.options = options;
    }

    public String classToTableName(String className) {
        String result = InternalUtils.StringUtils.join(this.options.getTablePrefix(), NamingStrategyUtils.classToPluralizedName(className));
        if (this.needRestrict(this.options.isRestrictTableNames())) {
            return this.assertName(new NameShorter(this.options.getMaxLength(), this.options.hasTablePrefix()).tableName(result), className, "@Table(name=\"prefix_table_name\")");
        }
        return result;
    }

    public String propertyToColumnName(String propertyName) {
        String result = InternalUtils.StringUtils.join(this.options.getColumnPrefix(), NamingStrategyUtils.propertyToName(propertyName));
        if (this.needRestrict(this.options.isRestrictColumnNames())) {
            return this.assertName(new NameShorter(this.options.getMaxLength(), this.options.hasColumnPrefix()).columnName(result), propertyName, "@Column(name=\"f_column_name\")");
        }
        return result;
    }

    public String embeddedPropertyToColumnName(String prefix, String embeddedPropertyName, boolean dontTouchPrefix) {
        String columnPrefix = dontTouchPrefix ? prefix : NamingStrategyUtils.propertyToName(prefix);
        String columnPostfix = NamingStrategyUtils.propertyToName(embeddedPropertyName);
        String fullColumnPrefix = InternalUtils.StringUtils.join(this.options.getColumnPrefix(), columnPrefix);
        if (!this.needRestrict(this.options.isRestrictEmbeddedColumnNames())) {
            return NamingStrategyUtils.concat(fullColumnPrefix, columnPostfix);
        }
        String result = null;
        if (dontTouchPrefix) {
            boolean dontTouchFirst = false;
            int maxPostfixLength = this.options.getMaxLength() - (fullColumnPrefix.length() + 1);
            result = NamingStrategyUtils.concat(fullColumnPrefix, new NameShorter(maxPostfixLength, false).embeddedColumnName(columnPostfix));
        } else {
            result = InternalUtils.StringUtils.join(this.options.getColumnPrefix(), HibernateNamingStrategy.embeddedColumnName(columnPrefix, columnPostfix, this.options.getMaxLength() - this.options.getColumnPrefixLength()));
        }
        return this.assertName(result, InternalUtils.StringUtils.joinWithSpace(prefix, embeddedPropertyName), "@AttributeOverrides({@AttributeOverride(name=\"propertyName\", column=@Column(\"f_column_name\"))");
    }

    private static String embeddedColumnName(String prefix, String property, int maxLength) {
        boolean dontTouchFirst = false;
        int maxPrefixlength = --maxLength - property.length();
        String prefixShorted = new NameShorter(maxPrefixlength, false).embeddedColumnName(prefix);
        int maxPropertyLength = maxLength - prefixShorted.length();
        String propertyShorted = new NameShorter(maxPropertyLength, false).embeddedColumnName(property);
        return NamingStrategyUtils.concat(prefixShorted, propertyShorted);
    }

    public String joinTableName(String ownerEntityTable, String associatedEntityTable) {
        return this.joinTableName(ownerEntityTable, associatedEntityTable, null);
    }

    public String joinTableName(String ownerEntityTable, String associatedEntityTable, String ownerProperty) {
        String ownerTable = NamingStrategyUtils.classToPluralizedName(ownerEntityTable);
        String associatedTable = NamingStrategyUtils.classToPluralizedName(associatedEntityTable);
        String result = ownerProperty == null ? NamingStrategyUtils.concat(ownerTable, associatedTable) : NamingStrategyUtils.concat(NamingStrategyUtils.concat(ownerTable, associatedTable), NamingStrategyUtils.propertyToName(ownerProperty));
        result = InternalUtils.StringUtils.join(this.options.getTablePrefix(), result);
        if (this.needRestrict(this.options.isRestrictJoinTableNames())) {
            return this.assertName(new NameShorter(this.options.getMaxLength(), this.options.hasTablePrefix()).joinTableName(result), InternalUtils.StringUtils.joinWithSpace(ownerEntityTable, associatedEntityTable, ownerProperty), "@JoinTable(name=\"prefix_join_table_name\")");
        }
        return result;
    }

    public String joinKeyColumnName(String joinedColumn, String joinedTable) {
        return NamingStrategyUtils.addUnderscores(joinedColumn) + "_id";
    }

    public String foreignKeyColumnName(String propertyName, String propertyTableName) {
        String header = propertyName != null ? NamingStrategyUtils.unqualify(propertyName) : propertyTableName;
        String result = InternalUtils.StringUtils.join(this.options.getForeignKeyColumnPrefix(), NamingStrategyUtils.addUnderscores(header));
        if (this.needRestrict(this.options.isRestrictColumnNames())) {
            return this.assertName(new NameShorter(this.options.getMaxLength(), this.options.hasForeignKeyColumnPrefix()).columnName(result), InternalUtils.StringUtils.joinWithSpace(propertyTableName, propertyName), "@JoinColumn(name=\"fk_name\")");
        }
        return result;
    }

    public String foreignKeyConstraintName(String tableName, String columnName) {
        String result = InternalUtils.StringUtils.join(this.options.getForeignKeyConstraintPrefix(), NamingStrategyUtils.concat(tableName, columnName));
        if (this.needRestrict(this.options.isRestrictConstraintNames())) {
            return this.assertName(new NameShorter(this.options.getMaxLength(), this.options.hasForeignKeyConstraintPrefix()).constraintName(result), "a foreign key constraint for " + InternalUtils.StringUtils.joinWithSpace(tableName, columnName), "@ForeignKey(name=\"fk_name\")");
        }
        return result;
    }

    public String uniqueKeyConstraintName(String tableName, String columnName) {
        String result = InternalUtils.StringUtils.join(this.options.getUniqueKeyConstraintPrefix(), NamingStrategyUtils.concat(tableName, columnName));
        if (this.needRestrict(this.options.isRestrictConstraintNames())) {
            return this.assertName(new NameShorter(this.options.getMaxLength(), this.options.hasUniqueKeyConstraintPrefix()).constraintName(result), InternalUtils.StringUtils.joinWithSpace(tableName, columnName), "@UniqueConstraint (if it is appropriate)");
        }
        return result;
    }

    private String assertName(String name, String object, String annotation) {
        int maxLength;
        int currentLength = name.length();
        if (currentLength > (maxLength = this.options.getMaxLength())) {
            InternalUtils.Asserts.fail(String.format("Can't restrict name of '%s'. Result '%s' has the length %d, max length is %d. Use '%s' to hardcode the name", object, name, currentLength, maxLength, annotation));
        }
        return name;
    }

    private boolean needRestrict(boolean toCheck) {
        return this.options.getMaxLength() > 0 && toCheck;
    }
}

