/*
 * Decompiled with CFR 0.152.
 */
package com.github.fluent.hibernate.cfg.strategy.hibernate4;

import com.github.fluent.hibernate.cfg.strategy.HibernateNamingStrategy;
import com.github.fluent.hibernate.cfg.strategy.JoinTableNames;
import com.github.fluent.hibernate.cfg.strategy.NamingStrategyUtils;
import com.github.fluent.hibernate.cfg.strategy.StrategyOptions;
import com.github.fluent.hibernate.internal.util.InternalUtils;
import org.hibernate.cfg.ImprovedNamingStrategy;

public class Hibernate4NamingStrategy
extends ImprovedNamingStrategy {
    private static final long serialVersionUID = -7668259354481970558L;
    private final HibernateNamingStrategy strategy;
    private final JoinTableNames joinTableNames = new JoinTableNames();

    public Hibernate4NamingStrategy() {
        this(new StrategyOptions());
    }

    public Hibernate4NamingStrategy(StrategyOptions options) {
        this.strategy = new HibernateNamingStrategy(options);
    }

    public void setTablePrefix(String tablePrefix) {
        this.strategy.getOptions().setTablePrefix(tablePrefix);
    }

    public void setMaxLength(int maxLength) {
        this.strategy.getOptions().setMaxLength(maxLength);
    }

    public String classToTableName(String className) {
        return this.strategy.classToTableName(className);
    }

    public String collectionTableName(String ownerEntity, String ownerEntityTable, String associatedEntity, String associatedEntityTable, String propertyName) {
        JoinTableNames.TableDescription description;
        String tableName = this.strategy.joinTableName(ownerEntityTable, associatedEntityTable);
        String result = this.joinTableNames.hasSameNameForOtherProperty(tableName, description = new JoinTableNames.TableDescription(ownerEntityTable, associatedEntityTable, propertyName)) ? this.strategy.joinTableName(ownerEntityTable, associatedEntityTable, propertyName) : tableName;
        this.joinTableNames.put(result, description);
        return result;
    }

    public String foreignKeyColumnName(String propertyName, String propertyEntityName, String propertyTableName, String referencedColumnName) {
        return this.strategy.foreignKeyColumnName(propertyName, propertyTableName);
    }

    public String joinKeyColumnName(String joinedColumn, String joinedTable) {
        return this.strategy.joinKeyColumnName(joinedColumn, joinedTable);
    }

    public String propertyToColumnName(String propertyName) {
        String forEmbedded = NamingStrategyUtils.addUnderscores(propertyName);
        return this.strategy.propertyToColumnName(forEmbedded);
    }

    public String logicalColumnName(String columnName, String propertyName) {
        return InternalUtils.StringUtils.isEmpty(columnName) ? propertyName : columnName;
    }
}

