/*
 * Decompiled with CFR 0.152.
 */
package com.github.fluent.hibernate.cfg.strategy.hibernate5;

import com.github.fluent.hibernate.annotations.FluentName;
import com.github.fluent.hibernate.cfg.strategy.HibernateNamingStrategy;
import com.github.fluent.hibernate.cfg.strategy.JoinTableNames;
import com.github.fluent.hibernate.cfg.strategy.StrategyOptions;
import com.github.fluent.hibernate.internal.util.InternalUtils;
import com.github.fluent.hibernate.internal.util.reflection.ReflectionUtils;
import java.lang.reflect.Field;
import java.util.List;
import org.hibernate.boot.model.naming.EntityNaming;
import org.hibernate.boot.model.naming.Identifier;
import org.hibernate.boot.model.naming.ImplicitBasicColumnNameSource;
import org.hibernate.boot.model.naming.ImplicitForeignKeyNameSource;
import org.hibernate.boot.model.naming.ImplicitJoinColumnNameSource;
import org.hibernate.boot.model.naming.ImplicitJoinTableNameSource;
import org.hibernate.boot.model.naming.ImplicitNameSource;
import org.hibernate.boot.model.naming.ImplicitNamingStrategyJpaCompliantImpl;
import org.hibernate.boot.model.naming.ImplicitUniqueKeyNameSource;
import org.hibernate.boot.model.source.spi.AttributePath;
import org.hibernate.cfg.Ejb3Column;

public class Hibernate5NamingStrategy
extends ImplicitNamingStrategyJpaCompliantImpl {
    private static final long serialVersionUID = 3482010804082494311L;
    private final HibernateNamingStrategy strategy;
    private final JoinTableNames joinTableNames = new JoinTableNames();

    public Hibernate5NamingStrategy() {
        this(new StrategyOptions());
    }

    public Hibernate5NamingStrategy(StrategyOptions options) {
        this.strategy = new HibernateNamingStrategy(options);
    }

    public void setOptions(StrategyOptions options) {
        this.strategy.setOptions(options);
    }

    public void setTablePrefix(String tablePrefix) {
        this.strategy.getOptions().setTablePrefix(tablePrefix);
    }

    public void setMaxLength(int maxLength) {
        this.strategy.getOptions().setMaxLength(maxLength);
    }

    protected String transformEntityName(EntityNaming entityNaming) {
        return this.strategy.classToTableName(entityNaming.getEntityName());
    }

    public Identifier determineBasicColumnName(ImplicitBasicColumnNameSource source) {
        AttributePath attributePath = source.getAttributePath();
        String propertyName = Hibernate5NamingStrategy.getPropertyName(attributePath);
        String parentPropertyName = Hibernate5NamingStrategy.getPropertyName(attributePath.getParent());
        Ejb3Column column = Hibernate5NamingStrategy.getEjb3Column(source);
        if (Hibernate5NamingStrategy.isEmbedded(column)) {
            String fluentNamePrefix = Hibernate5NamingStrategy.getFluentNamePrefix(column, parentPropertyName);
            boolean hasEmbeddedPrefix = !InternalUtils.StringUtils.isEmpty(fluentNamePrefix);
            String prefix = hasEmbeddedPrefix ? fluentNamePrefix : parentPropertyName;
            boolean dontTouchPrefix = hasEmbeddedPrefix;
            return Hibernate5NamingStrategy.toIdentifier(this.strategy.embeddedPropertyToColumnName(prefix, propertyName, dontTouchPrefix), (ImplicitNameSource)source);
        }
        if (!InternalUtils.StringUtils.isEmpty(parentPropertyName) && propertyName.equals("element")) {
            return Hibernate5NamingStrategy.toIdentifier(propertyName, (ImplicitNameSource)source);
        }
        return Hibernate5NamingStrategy.toIdentifier(this.strategy.propertyToColumnName(propertyName), (ImplicitNameSource)source);
    }

    private static String getFluentNamePrefix(Ejb3Column column, String propertyName) {
        Class mappedClass = column.getPropertyHolder().getPersistentClass().getMappedClass();
        FluentName fluentName = ReflectionUtils.getAnnotation(mappedClass, propertyName, FluentName.class);
        return fluentName == null ? null : fluentName.prefix();
    }

    private static boolean isEmbedded(Ejb3Column column) {
        return column.getPropertyHolder().isComponent();
    }

    private static Ejb3Column getEjb3Column(ImplicitBasicColumnNameSource source) {
        try {
            Field ejb3ColumnField = source.getClass().getDeclaredField("this$0");
            ReflectionUtils.makePublic(ejb3ColumnField);
            return (Ejb3Column)ejb3ColumnField.get(source);
        }
        catch (Exception ex) {
            throw InternalUtils.toRuntimeException(ex);
        }
    }

    public Identifier determineJoinColumnName(ImplicitJoinColumnNameSource source) {
        String propertyTableName = InternalUtils.ClassUtils.getShortName(source.getEntityNaming().getEntityName());
        String propertyName = Hibernate5NamingStrategy.getPropertyName(source.getAttributePath());
        String result = this.strategy.foreignKeyColumnName(propertyName, propertyTableName);
        return Hibernate5NamingStrategy.toIdentifier(result, (ImplicitNameSource)source);
    }

    public Identifier determineJoinTableName(ImplicitJoinTableNameSource source) {
        JoinTableNames.TableDescription description;
        String ownerEntityTable = source.getOwningEntityNaming().getEntityName();
        String associatedEntityTable = source.getNonOwningEntityNaming().getEntityName();
        String propertyName = Hibernate5NamingStrategy.getPropertyName(source.getAssociationOwningAttributePath());
        String tableName = this.strategy.joinTableName(ownerEntityTable, associatedEntityTable);
        String result = this.joinTableNames.hasSameNameForOtherProperty(tableName, description = new JoinTableNames.TableDescription(ownerEntityTable, associatedEntityTable, propertyName)) ? this.strategy.joinTableName(ownerEntityTable, associatedEntityTable, propertyName) : tableName;
        this.joinTableNames.put(result, description);
        return Hibernate5NamingStrategy.toIdentifier(result, (ImplicitNameSource)source);
    }

    public Identifier determineForeignKeyName(ImplicitForeignKeyNameSource source) {
        List columnNames = source.getColumnNames();
        if (InternalUtils.CollectionUtils.size(columnNames) != 1) {
            return super.determineForeignKeyName(source);
        }
        String result = this.strategy.foreignKeyConstraintName(source.getTableName().getText(), ((Identifier)columnNames.get(0)).getText());
        return Hibernate5NamingStrategy.toIdentifier(result, (ImplicitNameSource)source);
    }

    public Identifier determineUniqueKeyName(ImplicitUniqueKeyNameSource source) {
        List columnNames = source.getColumnNames();
        if (InternalUtils.CollectionUtils.size(columnNames) != 1) {
            return super.determineUniqueKeyName(source);
        }
        String result = this.strategy.uniqueKeyConstraintName(source.getTableName().getText(), ((Identifier)columnNames.get(0)).getText());
        return Hibernate5NamingStrategy.toIdentifier(result, (ImplicitNameSource)source);
    }

    private static String getPropertyName(AttributePath attributePath) {
        return attributePath == null ? null : attributePath.getProperty();
    }

    private static Identifier toIdentifier(String stringForm, ImplicitNameSource source) {
        return source.getBuildingContext().getMetadataCollector().getDatabase().getJdbcEnvironment().getIdentifierHelper().toIdentifier(stringForm);
    }
}

