/*
 * Decompiled with CFR 0.152.
 */
package com.github.fluent.hibernate.request;

import com.github.fluent.hibernate.internal.util.InternalUtils;
import javax.persistence.criteria.JoinType;
import org.hibernate.Criteria;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.DetachedCriteria;

final class Alias {
    private final String associationPath;
    private final String alias;
    private final JoinType joinType;
    private Criterion withClause;

    public Alias(String associationPath, String alias, JoinType joinType) {
        this.associationPath = associationPath;
        this.alias = alias;
        this.joinType = joinType;
    }

    public Alias(String associationPath, String alias, JoinType joinType, Criterion withClause) {
        this.associationPath = associationPath;
        this.alias = alias;
        this.joinType = joinType;
        this.withClause = withClause;
    }

    public void addToCriteria(Criteria criteria) {
        if (this.withClause == null) {
            criteria.createAlias(this.associationPath, this.alias, this.joinType.ordinal());
        } else {
            criteria.createAlias(this.associationPath, this.alias, this.joinType.ordinal(), this.withClause);
        }
    }

    public void addToCriteria(DetachedCriteria criteria) {
        if (this.joinType == null) {
            criteria.createAlias(this.associationPath, this.alias);
        } else if (this.withClause == null) {
            criteria.createAlias(this.associationPath, this.alias, this.joinType.ordinal());
        } else {
            criteria.createAlias(this.associationPath, this.alias, this.joinType.ordinal(), this.withClause);
        }
    }

    public int hashCode() {
        return InternalUtils.hashCode(this.associationPath, this.alias, this.joinType);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Alias other = (Alias)obj;
        return InternalUtils.equal(this.associationPath, other.associationPath) && InternalUtils.equal(this.alias, other.alias) && InternalUtils.equal(this.joinType, other.joinType) && InternalUtils.equal(this.withClause, other.withClause);
    }
}

