/*
 * Decompiled with CFR 0.152.
 */
package com.github.fluent.hibernate.request;

import com.github.fluent.hibernate.request.HibernateQuery;
import java.util.Arrays;
import java.util.List;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.transform.ResultTransformer;

public final class HibernateHqlRequest<T> {
    private final HibernateQuery<T> query;

    private HibernateHqlRequest(String query) {
        this.query = this.createQuery(query);
    }

    private HibernateQuery<T> createQuery(final String query) {
        return new HibernateQuery(new HibernateQuery.IQueryFactory(){

            @Override
            public Query create(Session session) {
                return session.createQuery(query);
            }
        });
    }

    public HibernateHqlRequest<T> p(String name, Object val) {
        this.query.p(name, val);
        return this;
    }

    public HibernateHqlRequest<T> p(String name, Object ... vals) {
        this.query.p(name, (Object)Arrays.asList(vals));
        return this;
    }

    public HibernateHqlRequest<T> maxResults(int maxResults) {
        this.query.maxResults(maxResults);
        return this;
    }

    public HibernateHqlRequest<T> transform(Class<?> clazz) {
        this.query.transform(clazz);
        return this;
    }

    public HibernateHqlRequest<T> useTransformer(ResultTransformer transformer) {
        this.query.useTransformer(transformer);
        return this;
    }

    public T first() {
        return this.query.first();
    }

    public List<T> list() {
        return this.query.list();
    }

    public int count() {
        return this.query.count();
    }

    public static <T> HibernateHqlRequest<T> create(String query) {
        return new HibernateHqlRequest<T>(query);
    }
}

