/*
 * Decompiled with CFR 0.152.
 */
package com.github.fluent.hibernate.request;

import com.github.fluent.hibernate.IRequest;
import com.github.fluent.hibernate.Pagination;
import com.github.fluent.hibernate.cfg.HibernateSessionFactory;
import com.github.fluent.hibernate.internal.util.InternalUtils;
import com.github.fluent.hibernate.request.aliases.Aliases;
import com.github.fluent.hibernate.request.builder.IBuilder;
import com.github.fluent.hibernate.transformer.FluentHibernateResultTransformer;
import java.util.Collection;
import java.util.List;
import javax.persistence.criteria.JoinType;
import org.hibernate.Criteria;
import org.hibernate.FetchMode;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.ProjectionList;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;
import org.hibernate.transform.ResultTransformer;

public final class HibernateRequest<T> {
    private final List<Criterion> restrictions = InternalUtils.CollectionUtils.newArrayList();
    private final ProjectionList projections = Projections.projectionList();
    private final Aliases aliases = Aliases.create();
    private final List<Order> orders = InternalUtils.CollectionUtils.newArrayList();
    private final Class<?> persistentClass;
    private String[] fetchJoinPaths;
    private boolean distinct;
    private ResultTransformer transformer;
    private Pagination pagination;
    private Integer maxResults;

    private HibernateRequest(Class<?> persistentClass) {
        this.persistentClass = persistentClass;
    }

    public static <T> HibernateRequest<T> create(Class<?> clazz) {
        return new HibernateRequest<T>(clazz);
    }

    public HibernateRequest<T> idEq(Object value) {
        this.restrictions.add(Restrictions.idEq((Object)value));
        return this;
    }

    public HibernateRequest<T> eqOrIsNull(String propertyName, Object value) {
        this.restrictions.add(Restrictions.eqOrIsNull((String)propertyName, (Object)value));
        return this;
    }

    public HibernateRequest<T> eq(String propertyName, Object value) {
        this.restrictions.add((Criterion)Restrictions.eq((String)propertyName, (Object)value));
        return this;
    }

    public HibernateRequest<T> ne(String propertyName, Object value) {
        this.restrictions.add((Criterion)Restrictions.ne((String)propertyName, (Object)value));
        return this;
    }

    public HibernateRequest<T> ge(String propertyName, Object value) {
        this.restrictions.add((Criterion)Restrictions.ge((String)propertyName, (Object)value));
        return this;
    }

    public HibernateRequest<T> gt(String propertyName, Object value) {
        this.restrictions.add((Criterion)Restrictions.gt((String)propertyName, (Object)value));
        return this;
    }

    public HibernateRequest<T> lt(String propertyName, Object value) {
        this.restrictions.add((Criterion)Restrictions.lt((String)propertyName, (Object)value));
        return this;
    }

    public HibernateRequest<T> le(String propertyName, Object value) {
        this.restrictions.add((Criterion)Restrictions.le((String)propertyName, (Object)value));
        return this;
    }

    public HibernateRequest<T> isNull(String propertyName) {
        this.restrictions.add(Restrictions.isNull((String)propertyName));
        return this;
    }

    public HibernateRequest<T> isNotNull(String propertyName) {
        this.restrictions.add(Restrictions.isNotNull((String)propertyName));
        return this;
    }

    public HibernateRequest<T> in(String propertyName, Collection<?> values) {
        if (!InternalUtils.CollectionUtils.isEmpty(values)) {
            this.restrictions.add(Restrictions.in((String)propertyName, values));
        }
        return this;
    }

    public <U> HibernateRequest<T> in(String propertyName, U ... values) {
        if (!InternalUtils.CollectionUtils.isEmpty(values)) {
            this.restrictions.add(Restrictions.in((String)propertyName, (Object[])values));
        }
        return this;
    }

    public HibernateRequest<T> add(Criterion criterion) {
        this.restrictions.add(criterion);
        return this;
    }

    public HibernateRequest<T> add(IBuilder ... builders) {
        for (IBuilder builder : builders) {
            builder.build(this);
        }
        return this;
    }

    public HibernateRequest<T> proj(String propertyName) {
        this.proj(Projections.property((String)propertyName).as(propertyName));
        return this;
    }

    public HibernateRequest<T> proj(String propertyName, String alias) {
        this.proj(Projections.property((String)propertyName).as(alias));
        return this;
    }

    public HibernateRequest<T> projId(String pidProperty) {
        this.proj(Projections.id().as(pidProperty));
        return this;
    }

    public HibernateRequest<T> projMin(String minProperty) {
        this.proj((Projection)Projections.min((String)minProperty));
        return this;
    }

    public HibernateRequest<T> projMax(String maxProperty) {
        this.proj((Projection)Projections.max((String)maxProperty));
        return this;
    }

    public HibernateRequest<T> proj(Projection projection) {
        this.projections.add(projection);
        return this;
    }

    public HibernateRequest<T> distinct() {
        this.distinct = true;
        return this;
    }

    public HibernateRequest<T> innerJoin(String associationPath) {
        this.innerJoin(associationPath, associationPath);
        return this;
    }

    public HibernateRequest<T> innerJoin(String associationPath, String alias) {
        this.aliases.add(associationPath, alias, JoinType.INNER);
        return this;
    }

    public HibernateRequest<T> innerJoin(String associationPath, String alias, Criterion withClause) {
        this.aliases.add(associationPath, alias, JoinType.INNER, withClause);
        return this;
    }

    public HibernateRequest<T> leftJoin(String associationPath) {
        this.leftJoin(associationPath, associationPath);
        return this;
    }

    public HibernateRequest<T> leftJoin(String associationPath, String alias) {
        this.aliases.add(associationPath, alias, JoinType.LEFT);
        return this;
    }

    public HibernateRequest<T> leftJoin(String associationPath, String alias, Criterion withClause) {
        this.aliases.add(associationPath, alias, JoinType.LEFT, withClause);
        return this;
    }

    public HibernateRequest<T> rightJoin(String associationPath) {
        this.rightJoin(associationPath, associationPath);
        return this;
    }

    public HibernateRequest<T> rightJoin(String associationPath, String alias) {
        this.aliases.add(associationPath, alias, JoinType.RIGHT);
        return this;
    }

    public HibernateRequest<T> rightJoin(String associationPath, String alias, Criterion withClause) {
        this.aliases.add(associationPath, alias, JoinType.RIGHT, withClause);
        return this;
    }

    public HibernateRequest<T> transform(Class<?> clazz) {
        this.transformer = new FluentHibernateResultTransformer(clazz);
        return this;
    }

    public HibernateRequest<T> distinctToRootEntity() {
        this.transformer = Criteria.DISTINCT_ROOT_ENTITY;
        return this;
    }

    public HibernateRequest<T> useTransformer(ResultTransformer transformer) {
        this.transformer = transformer;
        return this;
    }

    public HibernateRequest<T> pagination(Pagination pagination) {
        this.pagination = pagination;
        return this;
    }

    public HibernateRequest<T> maxResults(int maxResults) {
        this.maxResults = maxResults;
        return this;
    }

    public HibernateRequest<T> orderAsc(String propertyName) {
        this.orders.add(Order.asc((String)propertyName));
        return this;
    }

    public HibernateRequest<T> orderDesc(String propertyName) {
        this.orders.add(Order.desc((String)propertyName));
        return this;
    }

    public HibernateRequest<T> fetchJoin(String ... associationPaths) {
        this.fetchJoinPaths = associationPaths;
        return this;
    }

    public T first(T defaultValue) {
        T result = this.first();
        return result == null ? defaultValue : result;
    }

    public T first() {
        return InternalUtils.CollectionUtils.first(this.list());
    }

    public List<T> list() {
        return (List)HibernateSessionFactory.doInTransaction(new IRequest<List<T>>(){

            @Override
            public List<T> doInTransaction(Session session) {
                return HibernateRequest.this.tuneCriteriaForList(HibernateRequest.this.createCriteria(session)).list();
            }
        });
    }

    public int count() {
        Number result = HibernateSessionFactory.doInTransaction(new IRequest<Number>(){

            @Override
            public Number doInTransaction(Session session) {
                return (Number)HibernateRequest.this.count(HibernateRequest.this.createCriteria(session));
            }
        });
        return result == null ? 0 : result.intValue();
    }

    private Criteria createCriteria(Session session) {
        Criteria result = session.createCriteria(this.persistentClass);
        this.aliases.addToCriteria(result);
        for (Criterion restriction : this.restrictions) {
            result.add(restriction);
        }
        if (this.fetchJoinPaths != null) {
            for (String associationPath : this.fetchJoinPaths) {
                result.setFetchMode(associationPath, FetchMode.JOIN);
            }
        }
        return result;
    }

    private Criteria tuneCriteriaForList(Criteria criteria) {
        if (this.projections.getLength() > 0) {
            criteria.setProjection((Projection)(this.distinct ? Projections.distinct((Projection)this.projections) : this.projections));
        }
        if (this.transformer != null) {
            criteria.setResultTransformer(this.transformer);
        }
        for (Order order : this.orders) {
            criteria.addOrder(order);
        }
        if (this.maxResults != null) {
            criteria.setMaxResults(this.maxResults.intValue());
        }
        if (this.pagination != null) {
            this.pagination.addToCriteria(criteria);
        }
        return criteria;
    }

    private Object count(Criteria criteria) {
        criteria.setProjection(Projections.rowCount());
        return criteria.uniqueResult();
    }
}

