/*
 * Decompiled with CFR 0.152.
 */
package com.github.fluent.hibernate.request;

import com.github.fluent.hibernate.internal.util.InternalUtils;
import com.github.fluent.hibernate.request.HibernateQuery;
import com.github.fluent.hibernate.request.IToAddToSQLQuery;
import com.github.fluent.hibernate.request.SQLEntityToAdd;
import com.github.fluent.hibernate.request.SQLJoinToAdd;
import java.util.Arrays;
import java.util.List;
import org.hibernate.Query;
import org.hibernate.SQLQuery;
import org.hibernate.Session;
import org.hibernate.transform.ResultTransformer;

public final class HibernateSqlRequest<T> {
    private final HibernateQuery<T> query;
    private List<IToAddToSQLQuery> toAddToSQLQuery = InternalUtils.CollectionUtils.newArrayList();

    private HibernateSqlRequest(String query) {
        this.query = this.createQuery(query);
    }

    private HibernateQuery<T> createQuery(final String query) {
        return new HibernateQuery(new HibernateQuery.IQueryFactory(){

            @Override
            public Query create(Session session) {
                SQLQuery result = session.createSQLQuery(query);
                for (IToAddToSQLQuery toAdd : HibernateSqlRequest.this.toAddToSQLQuery) {
                    toAdd.addToQuery(result);
                }
                return result;
            }
        });
    }

    public HibernateSqlRequest<T> p(String name, Object val) {
        this.query.p(name, val);
        return this;
    }

    public HibernateSqlRequest<T> p(String name, Object ... vals) {
        this.query.p(name, (Object)Arrays.asList(vals));
        return this;
    }

    public HibernateSqlRequest<T> maxResults(int maxResults) {
        this.query.maxResults(maxResults);
        return this;
    }

    public HibernateSqlRequest<T> transform(Class<?> clazz) {
        this.query.transform(clazz);
        return this;
    }

    public HibernateSqlRequest<T> useTransformer(ResultTransformer transformer) {
        this.query.useTransformer(transformer);
        return this;
    }

    public T first() {
        return this.query.first();
    }

    public List<T> list() {
        return this.query.list();
    }

    public int count() {
        return this.query.count();
    }

    public HibernateSqlRequest<T> addEntity(Class<?> entityType) {
        return this.addEntity(null, entityType);
    }

    public HibernateSqlRequest<T> addEntity(String tableAlias, Class<?> entityType) {
        this.toAddToSQLQuery.add(new SQLEntityToAdd(tableAlias, entityType));
        return this;
    }

    public HibernateSqlRequest<T> addJoin(String tableAlias, String path) {
        return this.addJoin(tableAlias, path, null);
    }

    public HibernateSqlRequest<T> addJoin(String tableAlias, String ownerTableAlias, String joinPropertyName) {
        this.toAddToSQLQuery.add(new SQLJoinToAdd(tableAlias, ownerTableAlias, joinPropertyName));
        return this;
    }

    public static <T> HibernateSqlRequest<T> create(String query) {
        return new HibernateSqlRequest<T>(query);
    }
}

