/*
 * Decompiled with CFR 0.152.
 */
package com.browserup.bup.filters;

import com.browserup.bup.filters.HttpsAwareFiltersAdapter;
import com.browserup.bup.util.HttpStatusClass;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpObject;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.regex.Pattern;
import org.littleshoot.proxy.impl.ProxyUtils;

public class AllowlistFilter
extends HttpsAwareFiltersAdapter {
    private final boolean allowlistEnabled;
    private final int allowlistResponseCode;
    private final Collection<Pattern> allowlistUrls;

    public AllowlistFilter(HttpRequest originalRequest, ChannelHandlerContext ctx, boolean allowlistEnabled, int allowlistResponseCode, Collection<Pattern> allowlistUrls) {
        super(originalRequest, ctx);
        this.allowlistEnabled = allowlistEnabled;
        this.allowlistResponseCode = allowlistResponseCode;
        this.allowlistUrls = allowlistUrls != null ? allowlistUrls : Collections.emptyList();
    }

    public HttpResponse clientToProxyRequest(HttpObject httpObject) {
        if (!this.allowlistEnabled) {
            return null;
        }
        if (httpObject instanceof HttpRequest) {
            HttpRequest httpRequest = (HttpRequest)httpObject;
            if (ProxyUtils.isCONNECT((HttpObject)httpRequest)) {
                return null;
            }
            String url = this.getOriginalUrl();
            boolean urlAllowlisted = this.allowlistUrls.stream().anyMatch(pattern -> pattern.matcher(url).matches());
            if (!urlAllowlisted) {
                HttpResponseStatus status = HttpStatusClass.UNKNOWN.equals((Object)HttpStatusClass.valueOf(this.allowlistResponseCode)) ? new HttpResponseStatus(this.allowlistResponseCode, "Request blocked") : HttpResponseStatus.valueOf((int)this.allowlistResponseCode);
                DefaultFullHttpResponse resp = new DefaultFullHttpResponse(httpRequest.protocolVersion(), status);
                HttpUtil.setContentLength((HttpMessage)resp, (long)0L);
                return resp;
            }
        }
        return null;
    }
}

