/*
 * Decompiled with CFR 0.152.
 */
package com.browserup.bup.filters;

import com.browserup.bup.BrowserUpProxyServer;
import com.browserup.bup.filters.ModifiedRequestAwareFilter;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpObject;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpUtil;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.littleshoot.proxy.HttpFilters;
import org.littleshoot.proxy.HttpFiltersAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BrowserUpHttpFilterChain
extends HttpFiltersAdapter {
    private static final Logger log = LoggerFactory.getLogger(BrowserUpHttpFilterChain.class);
    private final BrowserUpProxyServer proxyServer;
    private final List<HttpFilters> filters;

    public BrowserUpHttpFilterChain(BrowserUpProxyServer proxyServer, HttpRequest originalRequest, ChannelHandlerContext ctx) {
        super(originalRequest, ctx);
        this.proxyServer = proxyServer;
        if (proxyServer.getFilterFactories() != null) {
            this.filters = new ArrayList<HttpFilters>(proxyServer.getFilterFactories().size());
            proxyServer.getFilterFactories().stream().map(filterFactory -> filterFactory.filterRequest(originalRequest, ctx)).filter(Objects::nonNull).forEach(this.filters::add);
        } else {
            this.filters = Collections.emptyList();
        }
    }

    public HttpResponse clientToProxyRequest(HttpObject httpObject) {
        if (this.proxyServer.isStopped()) {
            log.warn("Aborting request to {} because proxy is stopped", (Object)this.originalRequest.uri());
            DefaultFullHttpResponse abortedResponse = new DefaultFullHttpResponse(this.originalRequest.protocolVersion(), HttpResponseStatus.SERVICE_UNAVAILABLE);
            HttpUtil.setContentLength((HttpMessage)abortedResponse, (long)0L);
            return abortedResponse;
        }
        for (HttpFilters filter : this.filters) {
            try {
                HttpResponse filterResponse = filter.clientToProxyRequest(httpObject);
                if (filterResponse == null) continue;
                if (httpObject instanceof HttpRequest) {
                    this.updateFiltersWithModifiedResponse((HttpRequest)httpObject);
                }
                return filterResponse;
            }
            catch (RuntimeException e) {
                log.warn("Filter in filter chain threw exception. Filter method may have been aborted.", (Throwable)e);
            }
        }
        if (httpObject instanceof HttpRequest) {
            this.updateFiltersWithModifiedResponse((HttpRequest)httpObject);
        }
        return null;
    }

    public HttpResponse proxyToServerRequest(HttpObject httpObject) {
        for (HttpFilters filter : this.filters) {
            try {
                HttpResponse filterResponse = filter.proxyToServerRequest(httpObject);
                if (filterResponse == null) continue;
                return filterResponse;
            }
            catch (RuntimeException e) {
                log.warn("Filter in filter chain threw exception. Filter method may have been aborted.", (Throwable)e);
            }
        }
        return null;
    }

    public void proxyToServerRequestSending() {
        this.filters.forEach(filter -> {
            try {
                filter.proxyToServerRequestSending();
            }
            catch (RuntimeException e) {
                log.warn("Filter in filter chain threw exception. Filter method may have been aborted.", (Throwable)e);
            }
        });
    }

    public HttpObject serverToProxyResponse(HttpObject httpObject) {
        HttpObject processedHttpObject = httpObject;
        for (HttpFilters filter : this.filters) {
            try {
                if ((processedHttpObject = filter.serverToProxyResponse(processedHttpObject)) != null) continue;
                return null;
            }
            catch (RuntimeException e) {
                log.warn("Filter in filter chain threw exception. Filter method may have been aborted.", (Throwable)e);
            }
        }
        return processedHttpObject;
    }

    public void serverToProxyResponseTimedOut() {
        this.filters.forEach(filter -> {
            try {
                filter.serverToProxyResponseTimedOut();
            }
            catch (RuntimeException e) {
                log.warn("Filter in filter chain threw exception. Filter method may have been aborted.", (Throwable)e);
            }
        });
    }

    public void serverToProxyResponseReceiving() {
        this.filters.forEach(filter -> {
            try {
                filter.serverToProxyResponseReceiving();
            }
            catch (RuntimeException e) {
                log.warn("Filter in filter chain threw exception. Filter method may have been aborted.", (Throwable)e);
            }
        });
    }

    public InetSocketAddress proxyToServerResolutionStarted(String resolvingServerHostAndPort) {
        InetSocketAddress overrideAddress = null;
        String newServerHostAndPort = resolvingServerHostAndPort;
        for (HttpFilters filter : this.filters) {
            try {
                InetSocketAddress filterResult = filter.proxyToServerResolutionStarted(newServerHostAndPort);
                if (filterResult == null) continue;
                overrideAddress = filterResult;
                newServerHostAndPort = filterResult.getHostString() + ":" + filterResult.getPort();
            }
            catch (RuntimeException e) {
                log.warn("Filter in filter chain threw exception. Filter method may have been aborted.", (Throwable)e);
            }
        }
        return overrideAddress;
    }

    public void proxyToServerResolutionFailed(String hostAndPort) {
        this.filters.forEach(filter -> {
            try {
                filter.proxyToServerResolutionFailed(hostAndPort);
            }
            catch (RuntimeException e) {
                log.warn("Filter in filter chain threw exception. Filter method may have been aborted.", (Throwable)e);
            }
        });
    }

    public void proxyToServerResolutionSucceeded(String serverHostAndPort, InetSocketAddress resolvedRemoteAddress) {
        this.filters.forEach(filter -> {
            try {
                filter.proxyToServerResolutionSucceeded(serverHostAndPort, resolvedRemoteAddress);
            }
            catch (RuntimeException e) {
                log.warn("Filter in filter chain threw exception. Filter method may have been aborted.", (Throwable)e);
            }
        });
        super.proxyToServerResolutionSucceeded(serverHostAndPort, resolvedRemoteAddress);
    }

    public void proxyToServerConnectionStarted() {
        this.filters.forEach(filter -> {
            try {
                filter.proxyToServerConnectionStarted();
            }
            catch (RuntimeException e) {
                log.warn("Filter in filter chain threw exception. Filter method may have been aborted.", (Throwable)e);
            }
        });
    }

    public void proxyToServerConnectionSSLHandshakeStarted() {
        this.filters.forEach(filter -> {
            try {
                filter.proxyToServerConnectionSSLHandshakeStarted();
            }
            catch (RuntimeException e) {
                log.warn("Filter in filter chain threw exception. Filter method may have been aborted.", (Throwable)e);
            }
        });
    }

    public void proxyToServerConnectionFailed() {
        this.filters.forEach(filter -> {
            try {
                filter.proxyToServerConnectionFailed();
            }
            catch (RuntimeException e) {
                log.warn("Filter in filter chain threw exception. Filter method may have been aborted.", (Throwable)e);
            }
        });
    }

    public void proxyToServerConnectionSucceeded(ChannelHandlerContext serverCtx) {
        this.filters.forEach(filter -> {
            try {
                filter.proxyToServerConnectionSucceeded(serverCtx);
            }
            catch (RuntimeException e) {
                log.warn("Filter in filter chain threw exception. Filter method may have been aborted.", (Throwable)e);
            }
        });
    }

    public void proxyToServerRequestSent() {
        this.filters.forEach(filter -> {
            try {
                filter.proxyToServerRequestSent();
            }
            catch (RuntimeException e) {
                log.warn("Filter in filter chain threw exception. Filter method may have been aborted.", (Throwable)e);
            }
        });
    }

    public void serverToProxyResponseReceived() {
        this.filters.forEach(filter -> {
            try {
                filter.serverToProxyResponseReceived();
            }
            catch (RuntimeException e) {
                log.warn("Filter in filter chain threw exception. Filter method may have been aborted.", (Throwable)e);
            }
        });
    }

    public HttpObject proxyToClientResponse(HttpObject httpObject) {
        HttpObject processedHttpObject = httpObject;
        for (HttpFilters filter : this.filters) {
            try {
                if ((processedHttpObject = filter.proxyToClientResponse(processedHttpObject)) != null) continue;
                return null;
            }
            catch (RuntimeException e) {
                log.warn("Filter in filter chain threw exception. Filter method may have been aborted.", (Throwable)e);
            }
        }
        return processedHttpObject;
    }

    public void proxyToServerConnectionQueued() {
        this.filters.forEach(filter -> {
            try {
                filter.proxyToServerConnectionQueued();
            }
            catch (RuntimeException e) {
                log.warn("Filter in filter chain threw exception. Filter method may have been aborted.", (Throwable)e);
            }
        });
    }

    private void updateFiltersWithModifiedResponse(HttpRequest modifiedRequest) {
        for (HttpFilters filter : this.filters) {
            if (!(filter instanceof ModifiedRequestAwareFilter)) continue;
            ModifiedRequestAwareFilter requestCaptureFilter = (ModifiedRequestAwareFilter)filter;
            try {
                requestCaptureFilter.setModifiedHttpRequest(modifiedRequest);
            }
            catch (RuntimeException e) {
                log.warn("ModifiedRequestAwareFilter in filter chain threw exception while setting modified HTTP request.", (Throwable)e);
            }
        }
    }
}

