/*
 * Decompiled with CFR 0.152.
 */
package com.browserup.bup.filters;

import com.browserup.bup.filters.HttpsAwareFiltersAdapter;
import com.browserup.bup.filters.ModifiedRequestAwareFilter;
import com.browserup.bup.filters.ResponseFilter;
import com.browserup.bup.util.HttpMessageContents;
import com.browserup.bup.util.HttpMessageInfo;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.FullHttpMessage;
import io.netty.handler.codec.http.HttpObject;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import org.littleshoot.proxy.HttpFilters;
import org.littleshoot.proxy.HttpFiltersSourceAdapter;

public class ResponseFilterAdapter
extends HttpsAwareFiltersAdapter
implements ModifiedRequestAwareFilter {
    private final ResponseFilter responseFilter;
    private HttpRequest modifiedHttpRequest;

    public ResponseFilterAdapter(HttpRequest originalRequest, ChannelHandlerContext ctx, ResponseFilter responseFilter) {
        super(originalRequest, ctx);
        this.responseFilter = responseFilter;
    }

    public HttpObject serverToProxyResponse(HttpObject httpObject) {
        if (httpObject instanceof HttpResponse) {
            HttpMessageContents contents;
            HttpResponse httpResponse = (HttpResponse)httpObject;
            if (httpObject instanceof FullHttpMessage) {
                FullHttpMessage httpContent = (FullHttpMessage)httpObject;
                contents = new HttpMessageContents(httpContent);
            } else {
                contents = null;
            }
            HttpMessageInfo messageInfo = new HttpMessageInfo(this.originalRequest, this.ctx, this.isHttps(), this.getFullUrl(this.modifiedHttpRequest), this.getOriginalUrl());
            this.responseFilter.filterResponse(httpResponse, contents, messageInfo);
        }
        return super.serverToProxyResponse(httpObject);
    }

    @Override
    public void setModifiedHttpRequest(HttpRequest modifiedHttpRequest) {
        this.modifiedHttpRequest = modifiedHttpRequest;
    }

    public static class FilterSource
    extends HttpFiltersSourceAdapter {
        private static final int DEFAULT_MAXIMUM_RESPONSE_BUFFER_SIZE = 0xA00000;
        private final ResponseFilter filter;
        private final int maximumResponseBufferSizeInBytes;

        public FilterSource(ResponseFilter filter) {
            this.filter = filter;
            this.maximumResponseBufferSizeInBytes = 0xA00000;
        }

        public FilterSource(ResponseFilter filter, int maximumResponseBufferSizeInBytes) {
            this.filter = filter;
            this.maximumResponseBufferSizeInBytes = maximumResponseBufferSizeInBytes;
        }

        public HttpFilters filterRequest(HttpRequest originalRequest, ChannelHandlerContext ctx) {
            return new ResponseFilterAdapter(originalRequest, ctx, this.filter);
        }

        public int getMaximumResponseBufferSizeInBytes() {
            return this.maximumResponseBufferSizeInBytes;
        }
    }
}

