/*
 * Decompiled with CFR 0.152.
 */
package com.browserup.bup.filters;

import com.browserup.bup.util.BrowserUpHttpUtil;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpObject;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.LastHttpContent;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.littleshoot.proxy.HttpFiltersAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerResponseCaptureFilter
extends HttpFiltersAdapter {
    private static final Logger log = LoggerFactory.getLogger(ServerResponseCaptureFilter.class);
    private static final String BROTLI_COMPRESSION = "br";
    private volatile HttpResponse httpResponse;
    private final ByteArrayOutputStream rawResponseContents = new ByteArrayOutputStream();
    private volatile byte[] fullResponseContents;
    private volatile HttpHeaders trailingHeaders;
    private volatile boolean responseCompressed;
    private volatile boolean decompressionSuccessful;
    private volatile String contentEncoding;
    private final boolean decompressEncodedContent;

    public ServerResponseCaptureFilter(HttpRequest originalRequest, boolean decompressEncodedContent) {
        super(originalRequest);
        this.decompressEncodedContent = decompressEncodedContent;
    }

    public ServerResponseCaptureFilter(HttpRequest originalRequest, ChannelHandlerContext ctx, boolean decompressEncodedContent) {
        super(originalRequest, ctx);
        this.decompressEncodedContent = decompressEncodedContent;
    }

    public HttpObject serverToProxyResponse(HttpObject httpObject) {
        if (httpObject instanceof HttpResponse) {
            this.httpResponse = (HttpResponse)httpObject;
            this.captureContentEncoding(this.httpResponse);
        }
        if (httpObject instanceof HttpContent) {
            HttpContent httpContent = (HttpContent)httpObject;
            this.storeResponseContent(httpContent);
            if (httpContent instanceof LastHttpContent) {
                LastHttpContent lastContent = (LastHttpContent)httpContent;
                this.captureTrailingHeaders(lastContent);
                this.captureFullResponseContents();
            }
        }
        return super.serverToProxyResponse(httpObject);
    }

    protected void captureFullResponseContents() {
        this.fullResponseContents = this.getRawResponseContents();
        if (this.contentEncoding != null) {
            this.responseCompressed = true;
            if (this.decompressEncodedContent) {
                this.decompressContents();
            }
        } else {
            this.responseCompressed = false;
        }
    }

    protected void decompressContents() {
        if (this.contentEncoding.equals(HttpHeaderValues.GZIP.toString())) {
            try {
                this.fullResponseContents = BrowserUpHttpUtil.decompressGZIPContents(this.getRawResponseContents());
                this.decompressionSuccessful = true;
            }
            catch (RuntimeException e) {
                log.warn("Failed to decompress response with encoding type {} when decoding request from {}", new Object[]{this.contentEncoding, this.originalRequest.uri(), e});
            }
        } else if (this.contentEncoding.equals(BROTLI_COMPRESSION)) {
            try {
                this.fullResponseContents = BrowserUpHttpUtil.decompressBrotliContents(this.getRawResponseContents());
                this.decompressionSuccessful = true;
            }
            catch (RuntimeException e) {
                log.warn("Failed to decompress response with encoding type {} when decoding request from {}", new Object[]{this.contentEncoding, this.originalRequest.uri(), e});
            }
        } else {
            log.warn("Cannot decode unsupported content encoding type {}", (Object)this.contentEncoding);
        }
    }

    protected void captureContentEncoding(HttpResponse httpResponse) {
        this.contentEncoding = httpResponse.headers().get((CharSequence)HttpHeaderNames.CONTENT_ENCODING);
    }

    protected void captureTrailingHeaders(LastHttpContent lastContent) {
        String trailingContentEncoding;
        this.trailingHeaders = lastContent.trailingHeaders();
        if (this.trailingHeaders != null && (trailingContentEncoding = this.trailingHeaders.get((CharSequence)HttpHeaderNames.CONTENT_ENCODING)) != null) {
            this.contentEncoding = trailingContentEncoding;
        }
    }

    protected void storeResponseContent(HttpContent httpContent) {
        ByteBuf bufferedContent = httpContent.content();
        byte[] content = BrowserUpHttpUtil.extractReadableBytes(bufferedContent);
        try {
            this.rawResponseContents.write(content);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public HttpResponse getHttpResponse() {
        return this.httpResponse;
    }

    public byte[] getFullResponseContents() {
        return this.fullResponseContents;
    }

    public byte[] getRawResponseContents() {
        return this.rawResponseContents.toByteArray();
    }

    public HttpHeaders getTrailingHeaders() {
        return this.trailingHeaders;
    }

    public boolean isResponseCompressed() {
        return this.responseCompressed;
    }

    public boolean isDecompressionSuccessful() {
        if (!this.decompressEncodedContent) {
            return false;
        }
        return this.decompressionSuccessful;
    }

    public String getContentEncoding() {
        return this.contentEncoding;
    }
}

