/*
 * Decompiled with CFR 0.152.
 */
package com.browserup.bup.mitmproxy;

import com.browserup.bup.mitmproxy.NetworkUtils;
import com.browserup.bup.mitmproxy.addons.AbstractAddon;
import com.browserup.bup.mitmproxy.addons.AdditionalHeadersAddOn;
import com.browserup.bup.mitmproxy.addons.AddonsManagerAddOn;
import com.browserup.bup.mitmproxy.addons.AllowListAddOn;
import com.browserup.bup.mitmproxy.addons.AuthBasicAddOn;
import com.browserup.bup.mitmproxy.addons.BlockListAddOn;
import com.browserup.bup.mitmproxy.addons.HarCaptureAddOn;
import com.browserup.bup.mitmproxy.addons.HttpConnectCaptureAddOn;
import com.browserup.bup.mitmproxy.addons.InitFlowAddOn;
import com.browserup.bup.mitmproxy.addons.LatencyAddOn;
import com.browserup.bup.mitmproxy.addons.ProxyManagerAddOn;
import com.browserup.bup.mitmproxy.addons.RewriteUrlAddOn;
import com.browserup.bup.mitmproxy.management.AdditionalHeadersManager;
import com.browserup.bup.mitmproxy.management.AddonsManagerClient;
import com.browserup.bup.mitmproxy.management.AllowListManager;
import com.browserup.bup.mitmproxy.management.AuthBasicManager;
import com.browserup.bup.mitmproxy.management.BlockListManager;
import com.browserup.bup.mitmproxy.management.HarCaptureManager;
import com.browserup.bup.mitmproxy.management.LatencyManager;
import com.browserup.bup.mitmproxy.management.ProxyManager;
import com.browserup.bup.mitmproxy.management.RewriteUrlManager;
import java.io.OutputStream;
import java.net.BindException;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.SystemUtils;
import org.awaitility.Awaitility;
import org.awaitility.core.ConditionTimeoutException;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zeroturnaround.exec.ProcessExecutor;
import org.zeroturnaround.exec.StartedProcess;
import org.zeroturnaround.exec.stream.LogOutputStream;
import org.zeroturnaround.exec.stream.slf4j.Slf4jStream;

public class MitmProxyProcessManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(MitmProxyProcessManager.class);
    private static final String MITMPROXY_BINARY_PATH_PROPERTY = "MITMPROXY_BINARY_PATH";
    private static final String MITMPROXY_HOME_PATH = "/usr/local/bin";
    private static final String MITMPROXY_DEFAULT_BINARY_PATH = "/usr/local/bin/" + MitmProxyProcessManager.getMitmproxyBinaryFileName();
    private final int addonsManagerApiPort = NetworkUtils.getFreePort();
    private StartedProcess startedProcess = null;
    private HarCaptureAddOn harCaptureFilterAddOn = new HarCaptureAddOn();
    private ProxyManagerAddOn proxyManagerAddOn = new ProxyManagerAddOn();
    private AddonsManagerAddOn addonsManagerAddOn = new AddonsManagerAddOn(this.addonsManagerApiPort);
    private AllowListAddOn allowListAddOn = new AllowListAddOn();
    private BlockListAddOn blockListAddOn = new BlockListAddOn();
    private AuthBasicAddOn authBasicFilterAddOn = new AuthBasicAddOn();
    private AdditionalHeadersAddOn additionalHeadersAddOn = new AdditionalHeadersAddOn();
    private HttpConnectCaptureAddOn httpConnectCaptureAddOn = new HttpConnectCaptureAddOn();
    private RewriteUrlAddOn rewriteUrlAddOn = new RewriteUrlAddOn();
    private LatencyAddOn latencyAddOn = new LatencyAddOn();
    private InitFlowAddOn initFlowAddOn = new InitFlowAddOn();
    private AddonsManagerClient addonsManagerClient = new AddonsManagerClient(this.addonsManagerApiPort);
    private HarCaptureManager harCaptureFilterManager = new HarCaptureManager(this.addonsManagerClient, this);
    private ProxyManager proxyManager = new ProxyManager(this.addonsManagerClient, this);
    private AllowListManager allowListManager = new AllowListManager(this.addonsManagerClient, this);
    private BlockListManager blockListManager = new BlockListManager(this.addonsManagerClient, this);
    private AuthBasicManager authBasicFilterManager = new AuthBasicManager(this.addonsManagerClient, this);
    private AdditionalHeadersManager additionalHeadersManager = new AdditionalHeadersManager(this.addonsManagerClient, this);
    private RewriteUrlManager rewriteUrlManager = new RewriteUrlManager(this.addonsManagerClient, this);
    private LatencyManager latencyManager = new LatencyManager(this.addonsManagerClient, this);
    private Integer proxyPort = 0;
    private boolean isRunning = false;
    private boolean trustAll = false;
    private MitmProxyLoggingLevel mitmProxyLoggingLevel = MitmProxyLoggingLevel.info;
    private StringBuilder proxyLog = new StringBuilder();

    private static String getMitmproxyBinaryFileName() {
        return SystemUtils.IS_OS_WINDOWS ? "mitmdump.exe" : "mitmdump";
    }

    public void start(int port) {
        this.start(port == 0 ? NetworkUtils.getFreePort() : port, this.defaultAddons());
    }

    public void start(int port, List<AbstractAddon> addons) {
        try {
            this.proxyPort = port;
            this.startProxyWithRetries(port, addons, 3);
            this.isRunning = true;
            if (!addons.isEmpty()) {
                this.configureProxy();
            }
        }
        catch (Exception ex) {
            LOGGER.error("Failed to start proxy", (Throwable)ex);
            this.stop();
            throw ex;
        }
    }

    public MitmProxyLoggingLevel getMitmProxyLoggingLevel() {
        return this.mitmProxyLoggingLevel;
    }

    public void setMitmProxyLoggingLevel(MitmProxyLoggingLevel mitmProxyLoggingLevel) {
        this.mitmProxyLoggingLevel = mitmProxyLoggingLevel;
    }

    private void configureProxy() {
        this.harCaptureFilterManager.setHarCaptureTypes(this.harCaptureFilterManager.getLastCaptureTypes());
        this.authBasicFilterManager.getCredentials().forEach((key, value) -> this.authBasicFilterManager.authAuthorization((String)key, (String)value));
        this.additionalHeadersManager.addHeaders(this.additionalHeadersManager.getAllHeaders());
        this.rewriteUrlManager.rewriteUrls(this.rewriteUrlManager.getRewriteRulesMap());
        this.latencyManager.setLatency(this.latencyManager.getLatencyMs(), TimeUnit.MILLISECONDS);
        this.proxyManager.setConnectionIdleTimeout(this.proxyManager.getConnectionIdleTimeoutSeconds());
        this.proxyManager.setDnsResolvingDelayMs(this.proxyManager.getDnsResolutionDelayMs());
        this.proxyManager.setChainedProxyAuthorization(this.proxyManager.getUpstreamProxyCredentials());
        this.proxyManager.setChainedProxyNonProxyHosts(this.proxyManager.getUpstreamNonProxyHosts());
    }

    public Integer getProxyPort() {
        return this.proxyPort;
    }

    public boolean isRunning() {
        return this.isRunning;
    }

    public void stop() {
        this.isRunning = false;
        if (this.startedProcess != null) {
            Process process = this.startedProcess.getProcess();
            process.destroy();
            Awaitility.await().atMost(10L, TimeUnit.SECONDS).until(() -> !process.isAlive());
        }
    }

    public void setTrustAll(boolean trustAll) {
        this.trustAll = trustAll;
    }

    private List<AbstractAddon> defaultAddons() {
        AbstractAddon[] addonsArray = new AbstractAddon[]{this.initFlowAddOn, this.rewriteUrlAddOn, this.allowListAddOn, this.blockListAddOn, this.httpConnectCaptureAddOn, this.harCaptureFilterAddOn, this.addonsManagerAddOn, this.proxyManagerAddOn, this.authBasicFilterAddOn, this.additionalHeadersAddOn, this.latencyAddOn};
        return Arrays.asList(addonsArray);
    }

    private void startProxyWithRetries(int port, List<AbstractAddon> addons, int retryCount) {
        for (int attempt = 1; attempt <= retryCount; ++attempt) {
            try {
                this.startProxy(port, addons);
                break;
            }
            catch (Exception ex) {
                if (ex.getCause() != null && ex.getCause() instanceof BindException) {
                    throw ex;
                }
                if (attempt >= retryCount) {
                    LOGGER.error("Failed to start proxy, no retries left, throwing exception", (Throwable)ex);
                    throw ex;
                }
                LOGGER.error("Failed to start proxy, attempt: {}, retries count: {}, going to retry...", new Object[]{attempt, retryCount, ex});
                continue;
            }
        }
    }

    private void startProxy(int port, List<AbstractAddon> addons) {
        ArrayList<String> command = this.createCommand(port, addons);
        LOGGER.info("Starting proxy using command: {}", (Object)String.join((CharSequence)" ", command));
        ProcessExecutor processExecutor = this.createProcessExecutor(command);
        try {
            this.startedProcess = processExecutor.start();
        }
        catch (Exception ex) {
            throw new RuntimeException("Couldn't start mitmproxy process", ex);
        }
        this.waitForReady();
    }

    private void waitForReady() {
        try {
            Awaitility.await().atMost(15L, TimeUnit.SECONDS).until(this.proxyManager::callHealthCheck);
        }
        catch (ConditionTimeoutException ex) {
            this.handleHealthCheckFailure();
        }
    }

    @NotNull
    private ArrayList<String> createCommand(final int port, List<AbstractAddon> addons) {
        ArrayList<String> command = new ArrayList<String>(){
            {
                this.add(MitmProxyProcessManager.this.getMitmproxyBinaryPath());
                this.add("-p");
                this.add(String.valueOf(port));
                this.add("--set");
                this.add("confdir=/usr/local/bin");
            }
        };
        if (this.trustAll) {
            command.add("--ssl-insecure");
        }
        this.updateCommandWithUpstreamProxy((List<String>)command);
        this.updateCommandWithLogLevel((List<String>)command);
        this.updateCommandWithAddOns(addons, (List<String>)command);
        return command;
    }

    private String getMitmproxyBinaryPath() {
        String mitmproxyBinaryPathProperty = System.getProperty(MITMPROXY_BINARY_PATH_PROPERTY);
        if (mitmproxyBinaryPathProperty != null) {
            return mitmproxyBinaryPathProperty + "/" + MitmProxyProcessManager.getMitmproxyBinaryFileName();
        }
        return MITMPROXY_DEFAULT_BINARY_PATH;
    }

    private void handleHealthCheckFailure() {
        LOGGER.error("MitmProxy might not started properly, healthcheck failed for port: {}", (Object)this.proxyPort);
        if (this.startedProcess == null) {
            return;
        }
        if (this.startedProcess.getProcess().isAlive()) {
            LOGGER.error("MitmProxy's healthcheck failed but process is alive, killing mitmproxy process...");
            this.startedProcess.getProcess().destroyForcibly();
            try {
                Awaitility.await().atMost(5L, TimeUnit.SECONDS).until(() -> !this.startedProcess.getProcess().isAlive());
                LOGGER.info("MitmProxy process was killed successfully.");
            }
            catch (ConditionTimeoutException ex2) {
                LOGGER.error("Didn't manage to kill MitmProxy in time, throwing error");
                throw new RuntimeException("Couldn't kill mitmproxy in time", ex2);
            }
        }
        if (!this.startedProcess.getProcess().isAlive() && this.startedProcess.getProcess().exitValue() > 0) {
            BindException cause = null;
            if (this.proxyLog.toString().contains("Address already in use")) {
                cause = new BindException();
            }
            throw new RuntimeException("Couldn't start mitmproxy process on port: " + this.proxyPort + ", exit with code: " + this.startedProcess.getProcess().exitValue(), cause);
        }
    }

    private ProcessExecutor createProcessExecutor(List<String> command) {
        final String logPrefix = "MitmProxy[" + this.proxyPort + "]: ";
        return new ProcessExecutor(command).readOutput(true).destroyOnExit().redirectOutput((OutputStream)Slf4jStream.ofCaller().asInfo()).redirectOutput((OutputStream)new LogOutputStream(){

            protected void processLine(String line) {
                LOGGER.debug("{}{}", (Object)logPrefix, (Object)line);
                MitmProxyProcessManager.this.proxyLog.append(line).append("\n");
            }
        });
    }

    private void updateCommandWithAddOns(List<AbstractAddon> addons, List<String> command) {
        addons.forEach(addon -> command.addAll(Arrays.asList(addon.getCommandParams())));
    }

    private void updateCommandWithLogLevel(List<String> command) {
        MitmProxyLoggingLevel logLevel = this.getMitmProxyLoggingLevel();
        command.add("--set");
        command.add("termlog_verbosity=" + (Object)((Object)logLevel));
        if (logLevel.equals((Object)MitmProxyLoggingLevel.debug)) {
            command.add("--set");
            command.add("flow_detail=3");
        }
    }

    private void updateCommandWithUpstreamProxy(List<String> command) {
        InetSocketAddress upstreamProxyAddress = this.proxyManager.getUpstreamProxyAddress();
        if (upstreamProxyAddress != null) {
            String schema = "http";
            if (this.proxyManager.isUseHttpsUpstreamProxy()) {
                schema = "https";
            }
            command.add("--mode");
            command.add("upstream:" + schema + "://" + upstreamProxyAddress.getHostName() + ":" + upstreamProxyAddress.getPort());
        }
    }

    public HarCaptureManager getHarCaptureFilterManager() {
        return this.harCaptureFilterManager;
    }

    public ProxyManager getProxyManager() {
        return this.proxyManager;
    }

    public AllowListManager getAllowListManager() {
        return this.allowListManager;
    }

    public BlockListManager getBlockListManager() {
        return this.blockListManager;
    }

    public AuthBasicManager getAuthBasicFilterManager() {
        return this.authBasicFilterManager;
    }

    public AdditionalHeadersManager getAdditionalHeadersManager() {
        return this.additionalHeadersManager;
    }

    public RewriteUrlManager getRewriteUrlManager() {
        return this.rewriteUrlManager;
    }

    public LatencyManager getLatencyManager() {
        return this.latencyManager;
    }

    public int getAddonsManagerApiPort() {
        return this.addonsManagerApiPort;
    }

    public static enum MitmProxyLoggingLevel {
        error,
        warn,
        info,
        alert,
        debug;

    }
}

