/*
 * Decompiled with CFR 0.152.
 */
package com.browserup.bup.mitmproxy.management;

import com.browserup.bup.mitmproxy.MitmProxyProcessManager;
import com.browserup.bup.mitmproxy.management.AddonsManagerClient;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;

public class AdditionalHeadersManager {
    private final AddonsManagerClient addonsManagerClient;
    private final MitmProxyProcessManager mitmProxyManager;
    private final Map<String, String> headers = new HashMap<String, String>();

    public AdditionalHeadersManager(AddonsManagerClient addonsManagerClient, MitmProxyProcessManager mitmProxyManager) {
        this.addonsManagerClient = addonsManagerClient;
        this.mitmProxyManager = mitmProxyManager;
    }

    public void addHeaders(Map<String, String> headers) {
        this.headers.putAll(headers);
        if (!this.mitmProxyManager.isRunning()) {
            return;
        }
        List<Pair<String, String>> params = headers.entrySet().stream().map(e -> Pair.of(e.getKey(), e.getValue())).collect(Collectors.toList());
        this.addonsManagerClient.getRequestToAddonsManager("additional_headers", "add_headers", params, Void.class);
    }

    public void addHeader(final String name, final String value) {
        this.headers.put(name, value);
        if (!this.mitmProxyManager.isRunning()) {
            return;
        }
        this.addonsManagerClient.getRequestToAddonsManager("additional_headers", "add_header", (List<Pair<String, String>>)new ArrayList<Pair<String, String>>(){
            {
                this.add(Pair.of((Object)name, (Object)String.valueOf(value)));
            }
        }, Void.class);
    }

    public void removeHeader(final String name) {
        this.headers.remove(name);
        if (!this.mitmProxyManager.isRunning()) {
            return;
        }
        this.addonsManagerClient.getRequestToAddonsManager("additional_headers", "remove_header", (List<Pair<String, String>>)new ArrayList<Pair<String, String>>(){
            {
                this.add(Pair.of((Object)"name", (Object)String.valueOf(name)));
            }
        }, Void.class);
    }

    public void removeAllHeaders() {
        this.headers.clear();
        if (!this.mitmProxyManager.isRunning()) {
            return;
        }
        this.addonsManagerClient.getRequestToAddonsManager("additional_headers", "remove_all_headers", new ArrayList<Pair<String, String>>(), Void.class);
    }

    public Map<String, String> getAllHeaders() {
        return ImmutableMap.copyOf(this.headers);
    }
}

