/*
 * Decompiled with CFR 0.152.
 */
package com.browserup.bup.mitmproxy.management;

import com.browserup.bup.mitmproxy.MitmProxyProcessManager;
import com.browserup.bup.mitmproxy.management.AddonsManagerClient;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.tuple.Pair;

public class ProxyManager {
    private static final String SUCCESSFUL_HEALTH_CHECK_BODY = "OK";
    private final AddonsManagerClient addonsManagerClient;
    private final MitmProxyProcessManager mitmProxyManager;
    private long connectionIdleTimeoutSeconds = -1L;
    private long dnsResolutionDelayMs = -1L;
    private String upstreamProxyCredentials = "";
    private InetSocketAddress upstreamProxyAddress;
    private boolean useHttpsUpstreamProxy = false;
    private List<String> upstreamNonProxyHosts = new ArrayList<String>();

    public ProxyManager(AddonsManagerClient addonsManagerClient, MitmProxyProcessManager mitmProxyManager) {
        this.addonsManagerClient = addonsManagerClient;
        this.mitmProxyManager = mitmProxyManager;
    }

    public void setTrustAll(final Boolean trustAll) {
        if (!this.mitmProxyManager.isRunning()) {
            return;
        }
        this.addonsManagerClient.getRequestToAddonsManager("proxy_manager", "trust_all", (List<Pair<String, String>>)new ArrayList<Pair<String, String>>(){
            {
                this.add(Pair.of((Object)"trustAll", (Object)String.valueOf(trustAll)));
            }
        }, Void.class);
    }

    public void setConnectionIdleTimeout(final Long idleTimeoutSeconds) {
        this.connectionIdleTimeoutSeconds = idleTimeoutSeconds;
        if (!this.mitmProxyManager.isRunning()) {
            return;
        }
        this.addonsManagerClient.getRequestToAddonsManager("proxy_manager", "set_connection_timeout_idle", (List<Pair<String, String>>)new ArrayList<Pair<String, String>>(){
            {
                this.add(Pair.of((Object)"idleSeconds", (Object)String.valueOf(idleTimeoutSeconds)));
            }
        }, Void.class);
    }

    public void setDnsResolvingDelayMs(final Long delayMs) {
        this.dnsResolutionDelayMs = delayMs;
        if (!this.mitmProxyManager.isRunning()) {
            return;
        }
        this.addonsManagerClient.getRequestToAddonsManager("proxy_manager", "set_dns_resolving_delay_ms", (List<Pair<String, String>>)new ArrayList<Pair<String, String>>(){
            {
                this.add(Pair.of((Object)"delayMs", (Object)String.valueOf(delayMs)));
            }
        }, Void.class);
    }

    public void setChainedProxyAuthorization(final String chainedProxyCredentials) {
        this.upstreamProxyCredentials = chainedProxyCredentials;
        if (!this.mitmProxyManager.isRunning()) {
            return;
        }
        this.addonsManagerClient.getRequestToAddonsManager("proxy_manager", "set_upstream_proxy_authorization", (List<Pair<String, String>>)new ArrayList<Pair<String, String>>(){
            {
                this.add(Pair.of((Object)"credentials", (Object)String.valueOf(chainedProxyCredentials)));
            }
        }, Void.class);
    }

    public String getUpstreamProxyCredentials() {
        return this.upstreamProxyCredentials;
    }

    public long getConnectionIdleTimeoutSeconds() {
        return this.connectionIdleTimeoutSeconds;
    }

    public long getDnsResolutionDelayMs() {
        return this.dnsResolutionDelayMs;
    }

    public void setChainedHttpsProxy(boolean useHttpsUpstreamProxy) {
        this.useHttpsUpstreamProxy = useHttpsUpstreamProxy;
    }

    public void setChainedProxy(InetSocketAddress chainedProxyAddress) {
        this.upstreamProxyAddress = chainedProxyAddress;
    }

    public InetSocketAddress getUpstreamProxyAddress() {
        return this.upstreamProxyAddress;
    }

    public boolean isUseHttpsUpstreamProxy() {
        return this.useHttpsUpstreamProxy;
    }

    public List<String> getUpstreamNonProxyHosts() {
        return this.upstreamNonProxyHosts;
    }

    public void setChainedProxyNonProxyHosts(final List<String> upstreamNonProxyHosts) {
        this.upstreamNonProxyHosts = upstreamNonProxyHosts;
        if (!this.mitmProxyManager.isRunning()) {
            return;
        }
        this.addonsManagerClient.getRequestToAddonsManager("proxy_manager", "set_chained_proxy_non_proxy_hosts", (List<Pair<String, String>>)new ArrayList<Pair<String, String>>(){
            {
                this.add(Pair.of((Object)"nonProxyHosts", (Object)String.valueOf(upstreamNonProxyHosts)));
            }
        }, Void.class);
    }

    public Boolean callHealthCheck() {
        String result;
        try {
            result = this.addonsManagerClient.getRequestToAddonsManager("proxy_manager", "health_check", (List<Pair<String, String>>)new ArrayList<Pair<String, String>>(){
                {
                    this.add(Pair.of((Object)"nonProxyHosts", (Object)String.valueOf(ProxyManager.this.upstreamNonProxyHosts)));
                }
            }, String.class);
        }
        catch (Exception ex) {
            return false;
        }
        return SUCCESSFUL_HEALTH_CHECK_BODY.equals(result);
    }
}

