/*
 * Decompiled with CFR 0.152.
 */
package com.browserup.bup.mitmproxy.management;

import com.browserup.bup.mitmproxy.MitmProxyProcessManager;
import com.browserup.bup.mitmproxy.management.AddonsManagerClient;
import com.browserup.bup.proxy.RewriteRule;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;

public class RewriteUrlManager {
    private final AddonsManagerClient addonsManagerClient;
    private final MitmProxyProcessManager mitmProxyManager;
    private volatile CopyOnWriteArrayList<RewriteRule> rewriteRules = new CopyOnWriteArrayList();

    public RewriteUrlManager(AddonsManagerClient addonsManagerClient, MitmProxyProcessManager mitmProxyManager) {
        this.addonsManagerClient = addonsManagerClient;
        this.mitmProxyManager = mitmProxyManager;
    }

    public void rewriteUrl(final String pattern, final String replace) {
        this.rewriteRules.add(new RewriteRule(pattern, replace));
        if (!this.mitmProxyManager.isRunning()) {
            return;
        }
        this.addonsManagerClient.getRequestToAddonsManager("rewrite_url", "rewrite_url", (List<Pair<String, String>>)new ArrayList<Pair<String, String>>(){
            {
                this.add(Pair.of((Object)pattern, (Object)String.valueOf(replace)));
            }
        }, Void.class);
    }

    public void rewriteUrls(Map<String, String> rewriteRules) {
        this.rewriteRules = rewriteRules.entrySet().stream().map(rewriteRule -> new RewriteRule((String)rewriteRule.getKey(), (String)rewriteRule.getValue())).collect(Collectors.toCollection(CopyOnWriteArrayList::new));
        if (!this.mitmProxyManager.isRunning()) {
            return;
        }
        List<Pair<String, String>> params = rewriteRules.entrySet().stream().map(e -> Pair.of(e.getKey(), e.getValue())).collect(Collectors.toList());
        this.addonsManagerClient.getRequestToAddonsManager("rewrite_url", "rewrite_urls", params, Void.class);
    }

    public void removeRewriteRule(final String urlPattern) {
        this.rewriteRules.stream().filter(rewriteRule -> rewriteRule.getPattern().pattern().equals(urlPattern)).forEach(rewriteRule -> this.rewriteRules.remove(rewriteRule));
        if (!this.mitmProxyManager.isRunning()) {
            return;
        }
        this.addonsManagerClient.getRequestToAddonsManager("rewrite_url", "remove_rewrite_rule", (List<Pair<String, String>>)new ArrayList<Pair<String, String>>(){
            {
                this.add(Pair.of((Object)"pattern", (Object)String.valueOf(urlPattern)));
            }
        }, Void.class);
    }

    public void clearRewriteRules() {
        this.rewriteRules.clear();
        if (!this.mitmProxyManager.isRunning()) {
            return;
        }
        this.addonsManagerClient.getRequestToAddonsManager("rewrite_url", "clear_rewrite_rules", Collections.emptyList(), Void.class);
    }

    public CopyOnWriteArrayList<RewriteRule> getRewriteRules() {
        return this.rewriteRules;
    }

    public Map<String, String> getRewriteRulesMap() {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        this.rewriteRules.forEach(rewriteRule -> builder.put((Object)rewriteRule.getPattern().pattern(), (Object)rewriteRule.getReplace()));
        return builder.build();
    }
}

