/*
 * Decompiled with CFR 0.152.
 */
package com.browserup.bup.proxy.dns;

import com.browserup.bup.proxy.dns.AbstractHostNameRemapper;
import com.browserup.bup.proxy.dns.AdvancedHostResolver;
import com.google.common.net.InetAddresses;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xbill.DNS.AAAARecord;
import org.xbill.DNS.ARecord;
import org.xbill.DNS.Cache;
import org.xbill.DNS.Lookup;
import org.xbill.DNS.Record;
import org.xbill.DNS.TextParseException;

@Deprecated
public class DnsJavaResolver
extends AbstractHostNameRemapper
implements AdvancedHostResolver {
    private static final Logger log = LoggerFactory.getLogger(DnsJavaResolver.class);
    private final Cache cache = new Cache();
    private static final int DNS_NETWORK_FAILURE_RETRY_COUNT = 5;

    @Override
    public void clearDNSCache() {
        this.cache.clearCache();
    }

    @Override
    public void setPositiveDNSCacheTimeout(int timeout, TimeUnit timeUnit) {
        this.cache.setMaxCache((int)TimeUnit.SECONDS.convert(timeout, timeUnit));
    }

    @Override
    public void setNegativeDNSCacheTimeout(int timeout, TimeUnit timeUnit) {
        this.cache.setMaxNCache((int)TimeUnit.SECONDS.convert(timeout, timeUnit));
    }

    @Override
    public Collection<InetAddress> resolveRemapped(String remappedHost) {
        if (InetAddresses.isInetAddress((String)remappedHost)) {
            return Collections.singletonList(InetAddresses.forString((String)remappedHost));
        }
        Collection<InetAddress> ipv4addresses = this.resolveHostByType(remappedHost, 1);
        if (!ipv4addresses.isEmpty()) {
            return ipv4addresses;
        }
        return this.resolveHostByType(remappedHost, 28);
    }

    protected Collection<InetAddress> resolveHostByType(String host, int type) {
        Record[] records;
        Lookup lookup;
        try {
            lookup = new Lookup(host, type, 1);
        }
        catch (TextParseException e) {
            return Collections.emptyList();
        }
        lookup.setCache(this.cache);
        int retryCount = -1;
        do {
            records = lookup.run();
        } while (lookup.getResult() == 2 && ++retryCount < 5);
        if (records == null) {
            return Collections.emptyList();
        }
        ArrayList<InetAddress> addrList = new ArrayList<InetAddress>(records.length);
        Arrays.stream(records).forEach(record -> {
            if (record instanceof ARecord) {
                ARecord ipv4Record = (ARecord)record;
                try {
                    InetAddress resolvedAddress = InetAddress.getByAddress(host, ipv4Record.getAddress().getAddress());
                    addrList.add(resolvedAddress);
                }
                catch (UnknownHostException e) {
                    log.warn("dnsjava resolver returned an invalid InetAddress for host: " + host, (Throwable)e);
                }
            } else if (record instanceof AAAARecord) {
                AAAARecord ipv6Record = (AAAARecord)record;
                try {
                    InetAddress resolvedAddress = InetAddress.getByAddress(host, ipv6Record.getAddress().getAddress());
                    addrList.add(resolvedAddress);
                }
                catch (UnknownHostException e) {
                    log.warn("dnsjava resolver returned an invalid InetAddress for host: {}", (Object)host, (Object)e);
                }
            }
        });
        return addrList;
    }
}

