/*
 * Decompiled with CFR 0.152.
 */
package com.browserup.harreader.model;

import com.browserup.harreader.model.HarCookie;
import com.browserup.harreader.model.HarHeader;
import com.browserup.harreader.model.HarPostData;
import com.browserup.harreader.model.HarQueryParam;
import com.browserup.harreader.model.HttpMethod;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class HarRequest {
    protected static final Long DEFAULT_SIZE = -1L;
    private HttpMethod method = HttpMethod.GET;
    private String url = "";
    private String httpVersion = "HTTP/1.1";
    private List<HarCookie> cookies;
    private List<HarHeader> headers;
    private List<HarQueryParam> queryString;
    private HarPostData postData;
    private Long headersSize = DEFAULT_SIZE;
    private Long bodySize = DEFAULT_SIZE;
    private String comment;
    private Map<String, Object> additional = new HashMap<String, Object>();

    public HttpMethod getMethod() {
        return this.method;
    }

    public void setMethod(HttpMethod method) {
        this.method = method;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getHttpVersion() {
        return this.httpVersion;
    }

    public void setHttpVersion(String httpVersion) {
        this.httpVersion = httpVersion;
    }

    public List<HarCookie> getCookies() {
        if (this.cookies == null) {
            this.cookies = new ArrayList<HarCookie>();
        }
        return this.cookies;
    }

    public void setCookies(List<HarCookie> cookies) {
        this.cookies = cookies;
    }

    public List<HarHeader> getHeaders() {
        if (this.headers == null) {
            this.headers = new ArrayList<HarHeader>();
        }
        return this.headers;
    }

    public void setHeaders(List<HarHeader> headers) {
        this.headers = headers;
    }

    public List<HarQueryParam> getQueryString() {
        if (this.queryString == null) {
            this.queryString = new ArrayList<HarQueryParam>();
        }
        return this.queryString;
    }

    public void setQueryString(List<HarQueryParam> queryString) {
        this.queryString = queryString;
    }

    public HarPostData getPostData() {
        if (this.postData == null) {
            this.postData = new HarPostData();
        }
        return this.postData;
    }

    public void setPostData(HarPostData postData) {
        this.postData = postData;
    }

    public Long getHeadersSize() {
        if (this.headersSize == null) {
            return DEFAULT_SIZE;
        }
        return this.headersSize;
    }

    public void setHeadersSize(Long headersSize) {
        this.headersSize = headersSize;
    }

    public Long getBodySize() {
        if (this.bodySize == null) {
            return DEFAULT_SIZE;
        }
        return this.bodySize;
    }

    public void setBodySize(Long bodySize) {
        this.bodySize = bodySize;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditional() {
        return this.additional;
    }

    @JsonAnySetter
    public void setAdditionalField(String name, Object value) {
        this.additional.put(name, value);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HarRequest that = (HarRequest)o;
        return this.method == that.method && Objects.equals(this.url, that.url) && Objects.equals(this.httpVersion, that.httpVersion) && Objects.equals(this.cookies, that.cookies) && Objects.equals(this.headers, that.headers) && Objects.equals(this.queryString, that.queryString) && Objects.equals(this.postData, that.postData) && Objects.equals(this.headersSize, that.headersSize) && Objects.equals(this.bodySize, that.bodySize) && Objects.equals(this.comment, that.comment) && Objects.equals(this.additional, that.additional);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.method, this.url, this.httpVersion, this.cookies, this.headers, this.queryString, this.postData, this.headersSize, this.bodySize, this.comment, this.additional});
    }
}

