/*
 * Decompiled with CFR 0.152.
 */
package com.github.veithen.cosmos.equinox.datalocation;

import com.github.veithen.cosmos.equinox.datalocation.LocationImpl;
import java.io.IOException;
import java.net.URL;
import org.eclipse.osgi.service.datalocation.Location;

abstract class AbstractLocation
implements Location {
    private final Location parent;
    private final boolean readOnly;
    private URL location;

    AbstractLocation(Location parent, boolean readOnly) {
        this.parent = parent;
        this.readOnly = readOnly;
    }

    @Override
    public final boolean allowsDefault() {
        throw new UnsupportedOperationException();
    }

    @Override
    public final Location getParentLocation() {
        return this.parent;
    }

    @Override
    public final synchronized URL getURL() {
        URL defaultLocation;
        if (this.location == null && (defaultLocation = this.getDefault()) != null) {
            this.setURL(defaultLocation, false);
        }
        return this.location;
    }

    @Override
    public final synchronized boolean isSet() {
        return this.location != null;
    }

    @Override
    public final boolean isReadOnly() {
        return this.readOnly;
    }

    @Override
    public final boolean setURL(URL value, boolean lock) throws IllegalStateException {
        try {
            return this.set(value, lock);
        }
        catch (IOException ex) {
            return false;
        }
    }

    @Override
    public final synchronized boolean set(URL value, boolean lock) throws IllegalStateException, IOException {
        if (lock) {
            throw new UnsupportedOperationException();
        }
        if (this.location != null) {
            throw new IllegalStateException();
        }
        this.location = value;
        return true;
    }

    @Override
    public final boolean set(URL value, boolean lock, String lockFilePath) throws IllegalStateException, IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public final boolean lock() throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public final void release() {
        throw new UnsupportedOperationException();
    }

    @Override
    public final boolean isLocked() throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public final Location createLocation(Location parent, URL defaultValue, boolean readonly) {
        return new LocationImpl(parent, defaultValue, readonly);
    }

    @Override
    public final URL getDataArea(String path) throws IOException {
        throw new UnsupportedOperationException();
    }
}

