/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.resolver;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.felix.resolver.FelixResolveContext;
import org.apache.felix.resolver.SimpleHostedCapability;
import org.apache.felix.resolver.Util;
import org.apache.felix.resolver.WrappedCapability;
import org.apache.felix.resolver.WrappedRequirement;
import org.apache.felix.resolver.WrappedResource;
import org.apache.felix.resolver.util.CopyOnWriteList;
import org.apache.felix.resolver.util.CopyOnWriteSet;
import org.apache.felix.resolver.util.OpenHashMapList;
import org.apache.felix.resolver.util.OpenHashMapSet;
import org.apache.felix.resolver.util.ShadowList;
import org.osgi.framework.Version;
import org.osgi.resource.Capability;
import org.osgi.resource.Requirement;
import org.osgi.resource.Resource;
import org.osgi.resource.Wire;
import org.osgi.resource.Wiring;
import org.osgi.service.resolver.HostedCapability;
import org.osgi.service.resolver.ResolutionException;
import org.osgi.service.resolver.ResolveContext;

class Candidates {
    public static final int MANDATORY = 0;
    public static final int OPTIONAL = 1;
    private final Set<Resource> m_mandatoryResources;
    private final OpenHashMapSet<Capability, Requirement> m_dependentMap;
    private final OpenHashMapList<Requirement, Capability> m_candidateMap;
    private final Map<Resource, WrappedResource> m_allWrappedHosts;
    private final Map<Resource, Object> m_populateResultCache;
    private boolean m_fragmentsPresent = false;
    private final Map<Resource, Boolean> m_validOnDemandResources;
    private final Map<Capability, Requirement> m_subtitutableMap;
    private final OpenHashMapSet<Requirement, Capability> m_delta;
    private static final int UNPROCESSED = 0;
    private static final int PROCESSING = 1;
    private static final int SUBSTITUTED = 2;
    private static final int EXPORTED = 3;

    private Candidates(Set<Resource> mandatoryResources, OpenHashMapSet<Capability, Requirement> dependentMap, OpenHashMapList<Requirement, Capability> candidateMap, Map<Resource, WrappedResource> wrappedHosts, Map<Resource, Object> populateResultCache, boolean fragmentsPresent, Map<Resource, Boolean> onDemandResources, Map<Capability, Requirement> substitutableMap, OpenHashMapSet<Requirement, Capability> delta) {
        this.m_mandatoryResources = mandatoryResources;
        this.m_dependentMap = dependentMap;
        this.m_candidateMap = candidateMap;
        this.m_allWrappedHosts = wrappedHosts;
        this.m_populateResultCache = populateResultCache;
        this.m_fragmentsPresent = fragmentsPresent;
        this.m_validOnDemandResources = onDemandResources;
        this.m_subtitutableMap = substitutableMap;
        this.m_delta = delta;
    }

    public Candidates(Map<Resource, Boolean> validOnDemandResources) {
        this.m_mandatoryResources = new HashSet<Resource>();
        this.m_dependentMap = new OpenHashMapSet();
        this.m_candidateMap = new OpenHashMapList();
        this.m_allWrappedHosts = new HashMap<Resource, WrappedResource>();
        this.m_populateResultCache = new LinkedHashMap<Resource, Object>();
        this.m_validOnDemandResources = validOnDemandResources;
        this.m_subtitutableMap = new LinkedHashMap<Capability, Requirement>();
        this.m_delta = new OpenHashMapSet(3);
    }

    public Object getDelta() {
        return this.m_delta;
    }

    public final void populate(ResolveContext rc, Resource resource, int resolution) throws ResolutionException {
        block6: {
            Object cacheValue = this.m_populateResultCache.get(resource);
            if (cacheValue instanceof ResolutionException) {
                return;
            }
            if (cacheValue instanceof Boolean) {
                return;
            }
            boolean isFragment = Util.isFragment(resource);
            if (!isFragment && rc.getWirings().containsKey(resource)) {
                return;
            }
            if (resolution == 0) {
                this.m_mandatoryResources.add(resource);
            }
            try {
                this.populateResource(rc, resource);
            }
            catch (ResolutionException ex) {
                if (resolution != 0) break block6;
                throw ex;
            }
        }
    }

    private void populateResource(ResolveContext rc, Resource resource) throws ResolutionException {
        Integer cycleCount = null;
        Map<Requirement, List<Capability>> localCandidateMap = null;
        List remainingReqs = null;
        Object[] cacheValue = this.m_populateResultCache.get(resource);
        if (cacheValue instanceof ResolutionException) {
            throw (ResolutionException)cacheValue;
        }
        if (cacheValue instanceof Boolean) {
            return;
        }
        if (cacheValue != null) {
            Integer n = (Integer)((Object[])cacheValue)[0] + 1;
            ((Object[])cacheValue)[0] = n;
            cycleCount = n;
            localCandidateMap = (Map)((Object[])cacheValue)[1];
            remainingReqs = (List)((Object[])cacheValue)[2];
        }
        if (remainingReqs == null && localCandidateMap == null) {
            cycleCount = 0;
            localCandidateMap = new HashMap();
            remainingReqs = new ArrayList(resource.getRequirements(null));
            cacheValue = new Object[]{cycleCount, localCandidateMap, remainingReqs};
            this.m_populateResultCache.put(resource, cacheValue);
        }
        while (!remainingReqs.isEmpty()) {
            Requirement req = (Requirement)remainingReqs.remove(0);
            String resolution = (String)req.getDirectives().get("resolution");
            if (!rc.isEffective(req) || resolution != null && resolution.equals("dynamic")) continue;
            List candidates = rc.findProviders(req);
            ResolutionException rethrow = this.processCandidates(rc, resource, candidates);
            Object result = this.m_populateResultCache.get(resource);
            if (result instanceof ResolutionException) {
                throw (ResolutionException)((Object)result);
            }
            if (candidates.isEmpty() && !Util.isOptional(req)) {
                if (Util.isFragment(resource) && rc.getWirings().containsKey(resource)) {
                    this.m_populateResultCache.put(resource, Boolean.TRUE);
                    return;
                }
                String msg = "Unable to resolve " + resource + ": missing requirement " + req;
                if (rethrow != null) {
                    msg = msg + " [caused by: " + rethrow.getMessage() + "]";
                }
                rethrow = new ResolutionException(msg, null, Collections.singleton(req));
                this.m_populateResultCache.put(resource, (Object)rethrow);
                throw rethrow;
            }
            if (candidates.size() <= 0) continue;
            localCandidateMap.put(req, candidates);
        }
        if (cycleCount > 0) {
            ((Object[])cacheValue)[0] = cycleCount - 1;
        } else if (cycleCount == 0) {
            this.m_populateResultCache.put(resource, Boolean.TRUE);
            Iterator it = localCandidateMap.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                Iterator it2 = ((List)entry.getValue()).iterator();
                while (it2.hasNext()) {
                    if (!(this.m_populateResultCache.get(((Capability)it2.next()).getResource()) instanceof ResolutionException)) continue;
                    it2.remove();
                }
                if (!((List)entry.getValue()).isEmpty()) continue;
                it.remove();
            }
            if (localCandidateMap.size() > 0) {
                this.add(localCandidateMap);
            }
            if (rc instanceof FelixResolveContext && !Util.isFragment(resource)) {
                Collection<Resource> ondemandFragments = ((FelixResolveContext)rc).getOndemandResources(resource);
                for (Resource fragment : ondemandFragments) {
                    Boolean valid = this.m_validOnDemandResources.get(fragment);
                    if (valid == null) {
                        this.m_validOnDemandResources.put(fragment, Boolean.TRUE);
                        valid = Boolean.TRUE;
                    }
                    if (!valid.booleanValue()) continue;
                    this.populate(rc, fragment, 1);
                }
            }
        }
    }

    private void populateSubstitutables() {
        for (Map.Entry<Resource, Object> populated : this.m_populateResultCache.entrySet()) {
            if (!(populated.getValue() instanceof Boolean)) continue;
            this.populateSubstitutables(populated.getKey());
        }
    }

    private void populateSubstitutables(Resource resource) {
        List packageExports = resource.getCapabilities("osgi.wiring.package");
        if (packageExports.isEmpty()) {
            return;
        }
        List packageImports = resource.getRequirements("osgi.wiring.package");
        if (packageImports.isEmpty()) {
            return;
        }
        LinkedHashMap<String, ArrayList<Capability>> exportNames = new LinkedHashMap<String, ArrayList<Capability>>();
        for (Capability packageExport : packageExports) {
            String packageName = (String)packageExport.getAttributes().get("osgi.wiring.package");
            ArrayList<Capability> caps = (ArrayList<Capability>)exportNames.get(packageName);
            if (caps == null) {
                caps = new ArrayList<Capability>(1);
                exportNames.put(packageName, caps);
            }
            caps.add(packageExport);
        }
        for (Requirement req : packageImports) {
            String packageName;
            List exportedPackages;
            ArrayList substitutes = (ArrayList)this.m_candidateMap.get(req);
            if (substitutes == null || substitutes.isEmpty() || (exportedPackages = (List)exportNames.get(packageName = (String)((Capability)substitutes.iterator().next()).getAttributes().get("osgi.wiring.package"))) == null) continue;
            substitutes = new ArrayList(substitutes);
            for (Capability exportedPackage : exportedPackages) {
                substitutes.remove(exportedPackage);
            }
            if (substitutes.isEmpty()) continue;
            for (Capability exportedPackage : exportedPackages) {
                this.m_subtitutableMap.put(exportedPackage, req);
            }
        }
    }

    void checkSubstitutes(List<Candidates> importPermutations) throws ResolutionException {
        LinkedHashMap<Capability, Integer> substituteStatuses = new LinkedHashMap<Capability, Integer>(this.m_subtitutableMap.size());
        for (Capability capability : this.m_subtitutableMap.keySet()) {
            substituteStatuses.put(capability, 0);
        }
        for (Capability capability : this.m_subtitutableMap.keySet()) {
            this.isSubstituted(capability, substituteStatuses);
        }
        for (Map.Entry entry : substituteStatuses.entrySet()) {
            Set dependents;
            Requirement substitutedReq;
            if ((Integer)entry.getValue() == 2 && this.m_dependentMap.isEmpty()) {
                this.populateDependents();
            }
            if ((substitutedReq = this.m_subtitutableMap.get(entry.getKey())) != null) {
                this.permutateIfNeeded(substitutedReq, importPermutations);
            }
            if ((dependents = (Set)this.m_dependentMap.get(entry.getKey())) == null) continue;
            for (Requirement dependent : dependents) {
                List candidates = (List)this.m_candidateMap.get(dependent);
                if (candidates == null) continue;
                Iterator iCandidates = candidates.iterator();
                block7: while (iCandidates.hasNext()) {
                    Capability candidate = (Capability)iCandidates.next();
                    Integer candidateStatus = (Integer)substituteStatuses.get(candidate);
                    if (candidateStatus == null) {
                        candidateStatus = 3;
                    }
                    switch (candidateStatus) {
                        case 3: {
                            break block7;
                        }
                        default: {
                            iCandidates.remove();
                            continue block7;
                        }
                    }
                }
                if (!candidates.isEmpty()) continue;
                if (Util.isOptional(dependent)) {
                    this.m_candidateMap.remove(dependent);
                    continue;
                }
                String msg = "Unable to resolve " + dependent.getResource() + ": missing requirement " + dependent;
                throw new ResolutionException(msg, null, Collections.singleton(dependent));
            }
        }
    }

    private boolean isSubstituted(Capability substitutableCap, Map<Capability, Integer> substituteStatuses) {
        Integer substituteState = substituteStatuses.get(substitutableCap);
        if (substituteState == null) {
            return false;
        }
        switch (substituteState) {
            case 1: {
                substituteStatuses.put(substitutableCap, 3);
                return false;
            }
            case 2: {
                return true;
            }
            case 3: {
                return false;
            }
        }
        Requirement substitutableReq = this.m_subtitutableMap.get(substitutableCap);
        if (substitutableReq == null) {
            return false;
        }
        substituteStatuses.put(substitutableCap, 1);
        List substitutes = (List)this.m_candidateMap.get(substitutableReq);
        if (substitutes != null) {
            for (Capability substituteCandidate : substitutes) {
                if (substituteCandidate.getResource().equals((Object)substitutableCap.getResource())) {
                    substituteStatuses.put(substitutableCap, 3);
                    return false;
                }
                if (this.isSubstituted(substituteCandidate, substituteStatuses)) continue;
                substituteStatuses.put(substitutableCap, 2);
                return true;
            }
        }
        substituteStatuses.put(substitutableCap, 3);
        return false;
    }

    public void populateDynamic(ResolveContext rc, Resource resource, Requirement req, List<Capability> candidates) throws ResolutionException {
        this.m_mandatoryResources.add(resource);
        ResolutionException rethrow = this.processCandidates(rc, resource, candidates);
        this.add(req, candidates);
        if (candidates.isEmpty()) {
            if (rethrow == null) {
                rethrow = new ResolutionException("Dynamic import failed.", null, Collections.singleton(req));
            }
            throw rethrow;
        }
        this.m_populateResultCache.put(resource, Boolean.TRUE);
    }

    private ResolutionException processCandidates(ResolveContext rc, Resource resource, List<Capability> candidates) {
        ResolutionException rethrow = null;
        HashSet<Capability> fragmentCands = null;
        Iterator<Capability> itCandCap = candidates.iterator();
        while (itCandCap.hasNext()) {
            Capability candCap = itCandCap.next();
            boolean isFragment = Util.isFragment(candCap.getResource());
            if (isFragment) {
                if (fragmentCands == null) {
                    fragmentCands = new HashSet<Capability>();
                }
                fragmentCands.add(candCap);
            }
            if (!isFragment && rc.getWirings().containsKey(candCap.getResource()) || candCap.getResource().equals((Object)resource)) continue;
            try {
                this.populateResource(rc, candCap.getResource());
            }
            catch (ResolutionException ex) {
                if (rethrow == null) {
                    rethrow = ex;
                }
                itCandCap.remove();
            }
        }
        if (fragmentCands != null) {
            for (Capability fragCand : fragmentCands) {
                Wiring wiring;
                String fragCandName = fragCand.getNamespace();
                if ("osgi.identity".equals(fragCandName) || (wiring = (Wiring)rc.getWirings().get(fragCand.getResource())) == null) continue;
                for (Wire wire : wiring.getRequiredResourceWires("osgi.wiring.host")) {
                    if (fragCandName.equals("osgi.wiring.package") && !((Wiring)rc.getWirings().get(wire.getProvider())).getResourceCapabilities(null).contains(fragCand)) continue;
                    candidates.remove(fragCand);
                    rc.insertHostedCapability(candidates, (HostedCapability)new WrappedCapability(wire.getCapability().getResource(), fragCand));
                }
            }
        }
        return rethrow;
    }

    public boolean isPopulated(Resource resource) {
        Object value = this.m_populateResultCache.get(resource);
        return value != null && value instanceof Boolean;
    }

    public ResolutionException getResolveException(Resource resource) {
        Object value = this.m_populateResultCache.get(resource);
        return value != null && value instanceof ResolutionException ? (ResolutionException)((Object)value) : null;
    }

    private void add(Requirement req, List<Capability> candidates) {
        if (req.getNamespace().equals("osgi.wiring.host")) {
            this.m_fragmentsPresent = true;
        }
        this.m_candidateMap.put(req, (Capability)new CopyOnWriteList<Capability>(candidates));
    }

    private void add(Map<Requirement, List<Capability>> candidates) {
        for (Map.Entry<Requirement, List<Capability>> entry : candidates.entrySet()) {
            this.add(entry.getKey(), entry.getValue());
        }
    }

    public Resource getWrappedHost(Resource r) {
        Resource wrapped = this.m_allWrappedHosts.get(r);
        return wrapped == null ? r : wrapped;
    }

    public List<Capability> getCandidates(Requirement req) {
        List candidates = (List)this.m_candidateMap.get(req);
        if (candidates != null) {
            return Collections.unmodifiableList(candidates);
        }
        return null;
    }

    public Capability getFirstCandidate(Requirement req) {
        List candidates = (List)this.m_candidateMap.get(req);
        if (candidates != null && !candidates.isEmpty()) {
            return (Capability)((CopyOnWriteList)this.m_candidateMap.get(req)).get(0);
        }
        return null;
    }

    public void removeFirstCandidate(Requirement req) {
        CopyOnWriteSet<Capability> capPath;
        List candidates = (List)this.m_candidateMap.get(req);
        Capability cap = (Capability)candidates.remove(0);
        if (candidates.isEmpty()) {
            this.m_candidateMap.remove(req);
        }
        if ((capPath = (CopyOnWriteSet<Capability>)this.m_delta.get(req)) == null) {
            capPath = new CopyOnWriteSet<Capability>();
            this.m_delta.put(req, (Capability)capPath);
        }
        capPath.add(cap);
    }

    public List<Capability> clearCandidates(Requirement req, Collection<Capability> caps) {
        List l = (List)this.m_candidateMap.get(req);
        l.removeAll(caps);
        CopyOnWriteSet<Capability> capPath = (CopyOnWriteSet<Capability>)this.m_delta.get(req);
        if (capPath == null) {
            capPath = new CopyOnWriteSet<Capability>();
            this.m_delta.put(req, (Capability)capPath);
        }
        capPath.addAll(caps);
        return l;
    }

    public void prepare(ResolveContext rc) throws ResolutionException {
        Map<Object, Object> hostFragments = Collections.emptyMap();
        if (this.m_fragmentsPresent) {
            hostFragments = this.populateDependents();
        }
        ArrayList<WrappedResource> hostResources = new ArrayList<WrappedResource>();
        ArrayList<Resource> unselectedFragments = new ArrayList<Resource>();
        for (Map.Entry<Object, Object> hostEntry : hostFragments.entrySet()) {
            Capability hostCap = (Capability)hostEntry.getKey();
            Map fragments = (Map)hostEntry.getValue();
            ArrayList<Resource> selectedFragments = new ArrayList<Resource>();
            for (Map.Entry fragEntry : fragments.entrySet()) {
                boolean isFirst = true;
                for (Map.Entry versionEntry : ((Map)fragEntry.getValue()).entrySet()) {
                    for (Requirement hostReq : (List)versionEntry.getValue()) {
                        if (isFirst) {
                            selectedFragments.add(hostReq.getResource());
                            isFirst = false;
                            continue;
                        }
                        ((CopyOnWriteSet)this.m_dependentMap.get(hostCap)).remove(hostReq);
                        List hosts = (List)this.m_candidateMap.get(hostReq);
                        hosts.remove(hostCap);
                        if (!hosts.isEmpty()) continue;
                        unselectedFragments.add(hostReq.getResource());
                    }
                }
            }
            WrappedResource wrappedHost = new WrappedResource(hostCap.getResource(), selectedFragments);
            hostResources.add(wrappedHost);
            this.m_allWrappedHosts.put(hostCap.getResource(), wrappedHost);
        }
        for (Resource fragment : unselectedFragments) {
            this.removeResource(fragment, new ResolutionException("Fragment was not selected for attachment: " + fragment));
        }
        for (WrappedResource hostResource : hostResources) {
            for (Capability c : hostResource.getCapabilities(null)) {
                Capability origCap;
                CopyOnWriteSet dependents;
                if (c.getNamespace().equals("osgi.wiring.host") || (dependents = (CopyOnWriteSet)this.m_dependentMap.get(origCap = ((HostedCapability)c).getDeclaredCapability())) == null) continue;
                dependents = new CopyOnWriteSet(dependents);
                this.m_dependentMap.put(c, (Requirement)dependents);
                for (Requirement r : dependents) {
                    ShadowList cands = (ShadowList)this.m_candidateMap.get(r);
                    if (!(cands instanceof ShadowList)) {
                        ShadowList shadow = new ShadowList(cands);
                        this.m_candidateMap.put(r, (Capability)shadow);
                        cands = shadow;
                    }
                    if (!origCap.getResource().equals((Object)hostResource.getDeclaredResource())) {
                        List original = ((ShadowList)cands).getOriginal();
                        int removeIdx = original.indexOf(origCap);
                        if (removeIdx != -1) {
                            original.remove(removeIdx);
                            cands.remove(removeIdx);
                        }
                        int insertIdx = rc.insertHostedCapability(original, (HostedCapability)new SimpleHostedCapability(hostResource.getDeclaredResource(), origCap));
                        cands.add(insertIdx, c);
                        continue;
                    }
                    int idx = cands.indexOf(origCap);
                    cands.set(idx, c);
                }
            }
            for (Requirement r : hostResource.getRequirements(null)) {
                Requirement origReq = ((WrappedRequirement)r).getDeclaredRequirement();
                List cands = (List)this.m_candidateMap.get(origReq);
                if (cands == null) continue;
                this.m_candidateMap.put(r, (Capability)new CopyOnWriteList(cands));
                for (Capability cand : cands) {
                    Set dependents = (Set)this.m_dependentMap.get(cand);
                    dependents.remove(origReq);
                    dependents.add(r);
                }
            }
        }
        for (Resource resource : this.m_mandatoryResources) {
            if (this.isPopulated(resource)) continue;
            throw this.getResolveException(resource);
        }
        this.populateSubstitutables();
        this.m_candidateMap.concat();
        this.m_dependentMap.concat();
    }

    private Map<Capability, Map<String, Map<Version, List<Requirement>>>> populateDependents() {
        HashMap<Capability, Map<String, Map<Version, List<Requirement>>>> hostFragments = new HashMap<Capability, Map<String, Map<Version, List<Requirement>>>>();
        for (Map.Entry entry : this.m_candidateMap.entrySet()) {
            Requirement req = (Requirement)entry.getKey();
            List caps = (List)entry.getValue();
            for (Capability cap : caps) {
                ArrayList<Requirement> actual;
                TreeMap fragmentVersions;
                CopyOnWriteSet<Requirement> dependents = (CopyOnWriteSet<Requirement>)this.m_dependentMap.get(cap);
                if (dependents == null) {
                    dependents = new CopyOnWriteSet<Requirement>();
                    this.m_dependentMap.put(cap, (Requirement)dependents);
                }
                dependents.add(req);
                if (!req.getNamespace().equals("osgi.wiring.host")) continue;
                String resSymName = Util.getSymbolicName(req.getResource());
                Version resVersion = Util.getVersion(req.getResource());
                HashMap fragments = (HashMap)hostFragments.get(cap);
                if (fragments == null) {
                    fragments = new HashMap();
                    hostFragments.put(cap, fragments);
                }
                if ((fragmentVersions = (TreeMap)fragments.get(resSymName)) == null) {
                    fragmentVersions = new TreeMap(Collections.reverseOrder());
                    fragments.put(resSymName, fragmentVersions);
                }
                if ((actual = (ArrayList<Requirement>)fragmentVersions.get(resVersion)) == null) {
                    actual = new ArrayList<Requirement>();
                    if (resVersion == null) {
                        resVersion = new Version(0, 0, 0);
                    }
                    fragmentVersions.put(resVersion, actual);
                }
                actual.add(req);
            }
        }
        return hostFragments;
    }

    private void removeResource(Resource resource, ResolutionException ex) throws ResolutionException {
        this.m_populateResultCache.put(resource, (Object)ex);
        HashSet<Resource> unresolvedResources = new HashSet<Resource>();
        this.remove(resource, unresolvedResources);
        while (!unresolvedResources.isEmpty()) {
            Iterator it = unresolvedResources.iterator();
            resource = (Resource)it.next();
            it.remove();
            this.remove(resource, unresolvedResources);
        }
    }

    private void remove(Resource resource, Set<Resource> unresolvedResources) throws ResolutionException {
        for (Requirement r : resource.getRequirements(null)) {
            this.remove(r);
        }
        for (Capability c : resource.getCapabilities(null)) {
            this.remove(c, unresolvedResources);
        }
    }

    private void remove(Requirement req) {
        List candidates = (List)this.m_candidateMap.remove(req);
        if (candidates != null) {
            for (Capability cap : candidates) {
                Set dependents = (Set)this.m_dependentMap.get(cap);
                if (dependents == null) continue;
                dependents.remove(req);
            }
        }
    }

    private void remove(Capability c, Set<Resource> unresolvedResources) throws ResolutionException {
        Set dependents = (Set)this.m_dependentMap.remove(c);
        if (dependents != null) {
            for (Requirement r : dependents) {
                List candidates = (List)this.m_candidateMap.get(r);
                candidates.remove(c);
                if (!candidates.isEmpty()) continue;
                this.m_candidateMap.remove(r);
                if (Util.isOptional(r)) continue;
                String msg = "Unable to resolve " + r.getResource() + ": missing requirement " + r;
                this.m_populateResultCache.put(r.getResource(), (Object)new ResolutionException(msg, null, Collections.singleton(r)));
                unresolvedResources.add(r.getResource());
            }
        }
    }

    public Candidates copy() {
        return new Candidates(this.m_mandatoryResources, this.m_dependentMap.deepClone(), this.m_candidateMap.deepClone(), this.m_allWrappedHosts, this.m_populateResultCache, this.m_fragmentsPresent, this.m_validOnDemandResources, this.m_subtitutableMap, this.m_delta.deepClone());
    }

    public void dump(ResolveContext rc) {
        CopyOnWriteSet<Resource> resources = new CopyOnWriteSet<Resource>();
        for (Map.Entry entry : this.m_candidateMap.entrySet()) {
            resources.add(((Requirement)entry.getKey()).getResource());
        }
        System.out.println("=== BEGIN CANDIDATE MAP ===");
        for (Resource resource : resources) {
            List candidates;
            Wiring wiring = (Wiring)rc.getWirings().get(resource);
            System.out.println("  " + resource + " (" + (wiring != null ? "RESOLVED)" : "UNRESOLVED)"));
            List<Requirement> reqs = wiring != null ? wiring.getResourceRequirements(null) : resource.getRequirements(null);
            for (Requirement req : reqs) {
                candidates = (List)this.m_candidateMap.get(req);
                if (candidates == null || candidates.size() <= 0) continue;
                System.out.println("    " + req + ": " + candidates);
            }
            reqs = wiring != null ? Util.getDynamicRequirements(wiring.getResourceRequirements(null)) : Util.getDynamicRequirements(resource.getRequirements(null));
            for (Requirement req : reqs) {
                candidates = (List)this.m_candidateMap.get(req);
                if (candidates == null || candidates.size() <= 0) continue;
                System.out.println("    " + req + ": " + candidates);
            }
        }
        System.out.println("=== END CANDIDATE MAP ===");
    }

    public void permutate(Requirement req, List<Candidates> permutations) {
        if (!Util.isMultiple(req) && this.canRemoveCandidate(req)) {
            Candidates perm = this.copy();
            perm.removeFirstCandidate(req);
            permutations.add(perm);
        }
    }

    public boolean canRemoveCandidate(Requirement req) {
        List candidates = (List)this.m_candidateMap.get(req);
        return candidates != null && (candidates.size() > 1 || Util.isOptional(req));
    }

    public void permutateIfNeeded(Requirement req, List<Candidates> permutations) {
        List candidates = (List)this.m_candidateMap.get(req);
        if (candidates != null && candidates.size() > 1) {
            boolean permutated = false;
            for (Candidates existingPerm : permutations) {
                List existingPermCands = (List)existingPerm.m_candidateMap.get(req);
                if (existingPermCands == null || ((Capability)existingPermCands.get(0)).equals(candidates.get(0))) continue;
                permutated = true;
                break;
            }
            if (!permutated) {
                this.permutate(req, permutations);
            }
        }
    }
}

