/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.loader.classpath;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.security.ProtectionDomain;
import java.util.jar.Manifest;
import org.eclipse.osgi.framework.util.KeyedElement;
import org.eclipse.osgi.framework.util.KeyedHashSet;
import org.eclipse.osgi.storage.BundleInfo;
import org.eclipse.osgi.storage.bundlefile.BundleEntry;
import org.eclipse.osgi.storage.bundlefile.BundleFile;

public class ClasspathEntry {
    private final BundleFile bundlefile;
    private final ProtectionDomain domain;
    private final Manifest manifest;
    private KeyedHashSet userObjects = null;
    private final PDEData data;

    public ClasspathEntry(BundleFile bundlefile, ProtectionDomain domain, BundleInfo.Generation generation) {
        this.bundlefile = bundlefile;
        this.domain = domain;
        this.data = new PDEData(generation.getBundleFile().getBaseFile(), generation.getRevision().getSymbolicName());
        this.manifest = ClasspathEntry.getManifest(bundlefile, generation);
    }

    public BundleFile getBundleFile() {
        return this.bundlefile;
    }

    public ProtectionDomain getDomain() {
        return this.domain;
    }

    public synchronized Object getUserObject(Object key) {
        if (this.userObjects == null) {
            return null;
        }
        return this.userObjects.getByKey(key);
    }

    public synchronized void addUserObject(KeyedElement userObject) {
        if (this.userObjects == null) {
            this.userObjects = new KeyedHashSet(5, false);
        }
        this.userObjects.add(userObject);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Manifest getManifest(BundleFile cpBundleFile, BundleInfo.Generation generation) {
        if (!generation.hasPackageInfo() && generation.getBundleFile() == cpBundleFile) {
            return null;
        }
        BundleEntry mfEntry = cpBundleFile.getEntry("META-INF/MANIFEST.MF");
        if (mfEntry != null) {
            Manifest manifest;
            block8: {
                InputStream manIn = null;
                try {
                    manIn = mfEntry.getInputStream();
                    manifest = new Manifest(manIn);
                    if (manIn == null) break block8;
                }
                catch (Throwable throwable) {
                    try {
                        if (manIn != null) {
                            manIn.close();
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                }
                manIn.close();
            }
            return manifest;
        }
        return null;
    }

    public Manifest getManifest() {
        return this.manifest;
    }

    static final class PDEData {
        final String fileName;
        final String symbolicName;

        PDEData(File baseFile, String symbolicName) {
            this.fileName = baseFile == null ? null : baseFile.getAbsolutePath();
            this.symbolicName = symbolicName;
        }
    }
}

