/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.loader.sources;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import org.eclipse.osgi.internal.loader.BundleLoader;
import org.eclipse.osgi.internal.loader.sources.PackageSource;
import org.eclipse.osgi.internal.loader.sources.SingleSourcePackage;

public class MultiSourcePackage
extends PackageSource {
    private final SingleSourcePackage[] suppliers;

    public MultiSourcePackage(String id, SingleSourcePackage[] suppliers) {
        super(id);
        this.suppliers = suppliers;
    }

    @Override
    public SingleSourcePackage[] getSuppliers() {
        return this.suppliers;
    }

    @Override
    public Class<?> loadClass(String name) throws ClassNotFoundException {
        Class<?> result = null;
        for (int i = 0; i < this.suppliers.length; ++i) {
            result = this.suppliers[i].loadClass(name);
            if (result == null) continue;
            return result;
        }
        return result;
    }

    @Override
    public URL getResource(String name) {
        URL result = null;
        for (int i = 0; i < this.suppliers.length; ++i) {
            result = this.suppliers[i].getResource(name);
            if (result == null) continue;
            return result;
        }
        return result;
    }

    @Override
    public Enumeration<URL> getResources(String name) {
        Enumeration<URL> results = null;
        for (int i = 0; i < this.suppliers.length; ++i) {
            results = BundleLoader.compoundEnumerations(results, this.suppliers[i].getResources(name));
        }
        return results;
    }

    @Override
    public Collection<String> listResources(String path, String filePattern) {
        ArrayList<String> result = new ArrayList<String>();
        for (SingleSourcePackage source : this.suppliers) {
            Collection<String> sourceResources = source.listResources(path, filePattern);
            for (String resource : sourceResources) {
                if (result.contains(resource)) continue;
                result.add(resource);
            }
        }
        return result;
    }
}

