/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.log;

import java.util.ArrayList;
import java.util.List;

public class BasicReadWriteLock {
    private List<Thread> currentReaders = new ArrayList<Thread>(2);
    private int writersWaiting = 0;
    private Thread writing = null;

    public synchronized int readLock() {
        while (this.writing != null || this.writersWaiting != 0) {
            try {
                if (this.writing == Thread.currentThread()) {
                    throw new IllegalStateException("Attempted to nest read lock inside a write lock");
                }
                this.wait();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        this.currentReaders.add(Thread.currentThread());
        if (this.currentReaders.size() == 1) {
            return 1;
        }
        Thread current = Thread.currentThread();
        int result = 0;
        for (Thread reader : this.currentReaders) {
            if (reader != current) continue;
            ++result;
        }
        return result;
    }

    public synchronized void readUnlock() {
        this.currentReaders.remove(Thread.currentThread());
        this.notifyAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void writeLock() {
        ++this.writersWaiting;
        try {
            while (this.writing != null || this.currentReaders.size() != 0) {
                try {
                    if (this.writing == Thread.currentThread() || this.currentReaders.contains(Thread.currentThread())) {
                        throw new IllegalStateException("Attempted to nest write lock inside a read or write lock");
                    }
                    this.wait();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
        }
        finally {
            --this.writersWaiting;
        }
        this.writing = Thread.currentThread();
    }

    public synchronized void writeUnlock() {
        this.writing = null;
        this.notifyAll();
    }
}

