/*
 * Decompiled with CFR 0.152.
 */
package com.github.veithen.maven.emf;

import org.eclipse.emf.common.util.BasicMonitor;
import org.eclipse.emf.common.util.Diagnostic;
import org.slf4j.Logger;

final class DebugMonitor
extends BasicMonitor {
    private final Logger logger;

    DebugMonitor(Logger logger) {
        this.logger = logger;
    }

    public void beginTask(String name, int totalWork) {
        if (this.logger.isDebugEnabled() && name != null && !name.isEmpty()) {
            this.logger.debug(">>> " + name);
        }
    }

    public void setTaskName(String name) {
        if (this.logger.isDebugEnabled() && name != null && !name.isEmpty()) {
            this.logger.debug("<>> " + name);
        }
    }

    public void subTask(String name) {
        if (this.logger.isDebugEnabled() && name != null && !name.isEmpty()) {
            this.logger.debug(">>  " + name);
        }
    }

    public void setBlocked(Diagnostic reason) {
        super.setBlocked(reason);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("#>  " + reason.getMessage());
        }
    }

    public void clearBlocked() {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("=>  " + this.getBlockedReason().getMessage());
        }
        super.clearBlocked();
    }
}

