/*
 * Decompiled with CFR 0.152.
 */
package com.github.veithen.maven.emf;

import com.github.veithen.maven.emf.DebugMonitor;
import com.github.veithen.maven.emf.EMFMojo;
import com.github.veithen.maven.emf.EMFUtil;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.eclipse.core.internal.resources.ProjectDescription;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.codegen.ecore.generator.Generator;
import org.eclipse.emf.codegen.ecore.genmodel.GenModel;
import org.eclipse.emf.common.util.BasicMonitor;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.Monitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class GenerateMojo
extends EMFMojo {
    private static final Logger logger = LoggerFactory.getLogger(GenerateMojo.class);
    @Parameter(property="project", required=true, readonly=true)
    private MavenProject project;
    @Parameter(property="mojoExecution", required=true, readonly=true)
    private MojoExecution mojoExecution;
    @Parameter(required=true)
    private File genmodel;
    @Parameter(required=true, defaultValue="${project.build.directory}/generated-sources/emf")
    private File outputDirectory;

    @Override
    protected void doExecute() throws MojoExecutionException, MojoFailureException {
        try {
            this.generate(EMFUtil.loadGenModel(this.genmodel));
        }
        catch (IOException ex) {
            throw new MojoFailureException(ex.getMessage(), (Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generate(GenModel genmodel) throws MojoExecutionException, MojoFailureException {
        genmodel.reconcile();
        DebugMonitor monitor = new DebugMonitor(logger);
        IProgressMonitor progressMonitor = BasicMonitor.toIProgressMonitor((Monitor)monitor);
        String eclipseProjectName = this.project.getGroupId() + "-" + this.project.getArtifactId() + "-" + this.mojoExecution.getGoal() + "-" + this.mojoExecution.getExecutionId();
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IProject eclipseProject = root.getProject(eclipseProjectName);
        ProjectDescription projectDescription = new ProjectDescription();
        projectDescription.setName(eclipseProjectName);
        projectDescription.setLocationURI(this.outputDirectory.toURI());
        try {
            eclipseProject.create((IProjectDescription)projectDescription, progressMonitor);
        }
        catch (CoreException ex) {
            throw new MojoFailureException("Unable to create Eclipse project", (Throwable)ex);
        }
        try {
            try {
                eclipseProject.open(progressMonitor);
            }
            catch (CoreException ex) {
                throw new MojoFailureException("Unable to open Eclipse project", (Throwable)ex);
            }
            Generator gen = new Generator();
            gen.setInput((Object)genmodel);
            genmodel.setModelPluginID(null);
            genmodel.setCanGenerate(true);
            if (!gen.canGenerate((Object)genmodel, (Object)"org.eclipse.emf.codegen.ecore.genmodel.generator.ModelProject")) {
                throw new MojoExecutionException("canGenerate returned false");
            }
            genmodel.setModelDirectory(eclipseProjectName);
            Diagnostic diagnostic = gen.generate((Object)genmodel, (Object)"org.eclipse.emf.codegen.ecore.genmodel.generator.ModelProject", (Monitor)monitor);
            if (diagnostic.getSeverity() != 0) {
                System.out.println("Diagnostic:");
                GenerateMojo.printDiagnostic(0, diagnostic);
                throw new MojoExecutionException("Code generation failed; see diagnostic for details");
            }
        }
        finally {
            try {
                eclipseProject.delete(false, true, progressMonitor);
            }
            catch (CoreException ex) {
                throw new MojoFailureException("Unable to delete Eclipse project", (Throwable)ex);
            }
        }
        this.addSourceRoot(this.project, this.outputDirectory.toString());
        Resource resource = new Resource();
        resource.setDirectory(this.outputDirectory.toString());
        resource.setExcludes(Arrays.asList(".project", "**/*.java"));
        this.addResource(this.project, resource);
    }

    private static void printDiagnostic(int level, Diagnostic diagnostic) {
        for (int i = 0; i < level; ++i) {
            System.out.print("  ");
        }
        System.out.println(diagnostic.getMessage());
        for (Diagnostic child : diagnostic.getChildren()) {
            if (child.getSeverity() == 0) continue;
            GenerateMojo.printDiagnostic(level + 1, child);
        }
    }

    protected abstract void addSourceRoot(MavenProject var1, String var2);

    protected abstract void addResource(MavenProject var1, Resource var2);
}

