/*
 * Decompiled with CFR 0.152.
 */
package com.github.veithen.maven.jacoco;

import com.github.veithen.maven.jacoco.CoverageContext;
import com.github.veithen.maven.jacoco.CoverageService;
import com.github.veithen.maven.jacoco.Source;
import com.github.veithen.maven.jacoco.TravisContext;
import java.util.Iterator;
import javax.json.Json;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonValue;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.MediaType;
import org.jacoco.core.analysis.ICounter;
import org.jacoco.core.analysis.ILine;
import org.jacoco.core.analysis.IPackageCoverage;
import org.jacoco.core.analysis.ISourceFileCoverage;

final class Codecov
implements CoverageService {
    private final WebTarget target;

    Codecov(WebTarget target) {
        this.target = target;
    }

    @Override
    public String getName() {
        return "Codecov";
    }

    @Override
    public boolean isEnabled(TravisContext travisContext) {
        if (travisContext == null) {
            return false;
        }
        try {
            this.target.path("api/gh/{user}/{repo}").resolveTemplate("user", (Object)travisContext.getUser()).resolveTemplate("repo", (Object)travisContext.getRepository()).request().accept(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).get(JsonObject.class);
            return true;
        }
        catch (NotFoundException ex) {
            return false;
        }
    }

    @Override
    public String upload(TravisContext travisContext, CoverageContext coverageContext) {
        JsonObjectBuilder sourceFilesBuilder = Json.createObjectBuilder();
        for (IPackageCoverage packageCoverage : coverageContext.getBundle().getPackages()) {
            ISourceFileCoverage sourceFileCoverage;
            Source source;
            Iterator iterator = packageCoverage.getSourceFiles().iterator();
            while (iterator.hasNext() && (source = coverageContext.lookupSource(sourceFileCoverage = (ISourceFileCoverage)iterator.next())) != null) {
                JsonObjectBuilder coverageBuilder = Json.createObjectBuilder();
                for (int i = sourceFileCoverage.getFirstLine(); i <= sourceFileCoverage.getLastLine(); ++i) {
                    ILine line = sourceFileCoverage.getLine(i);
                    if (line.getStatus() == 0) continue;
                    ICounter branchCounter = line.getBranchCounter();
                    String value = branchCounter.getTotalCount() > 0 ? String.format("%s/%s", branchCounter.getCoveredCount(), branchCounter.getTotalCount()) : (line.getStatus() == 1 ? "0" : "1");
                    coverageBuilder.add(String.valueOf(i), value);
                }
                sourceFilesBuilder.add(source.getPathRelativeToRepositoryRoot(), (JsonValue)coverageBuilder.build());
            }
        }
        JsonObject report = Json.createObjectBuilder().add("coverage", (JsonValue)sourceFilesBuilder.build()).build();
        this.target.path("upload/v2").queryParam("service", new Object[]{"travis"}).queryParam("slug", new Object[]{travisContext.getRepoSlug()}).queryParam("job", new Object[]{travisContext.getJobId()}).queryParam("build", new Object[]{travisContext.getJobNumber()}).queryParam("build_url", new Object[]{travisContext.getJobUrl()}).queryParam("branch", new Object[]{travisContext.getBranch()}).queryParam("commit", new Object[]{travisContext.getCommit()}).request().post(Entity.entity((Object)report, (MediaType)MediaType.APPLICATION_JSON_TYPE), String.class);
        return this.target.path("gh/{user}/{repo}/tree/{commit}").resolveTemplate("user", (Object)travisContext.getUser()).resolveTemplate("repo", (Object)travisContext.getRepository()).resolveTemplate("commit", (Object)travisContext.getCommit()).getUri().toString();
    }
}

