/*
 * Decompiled with CFR 0.152.
 */
package com.github.veithen.maven.jacoco;

import com.github.veithen.maven.jacoco.CoverageContext;
import com.github.veithen.maven.jacoco.CoverageService;
import com.github.veithen.maven.jacoco.MultiReportOutput;
import com.github.veithen.maven.jacoco.TravisContext;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.net.ConnectException;
import java.util.Locale;
import javax.json.Json;
import javax.json.JsonObject;
import javax.ws.rs.ProcessingException;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.MediaType;
import org.apache.maven.plugin.MojoFailureException;
import org.glassfish.jersey.media.multipart.BodyPart;
import org.glassfish.jersey.media.multipart.FormDataBodyPart;
import org.glassfish.jersey.media.multipart.FormDataContentDisposition;
import org.glassfish.jersey.media.multipart.FormDataMultiPart;
import org.jacoco.report.IMultiReportOutput;
import org.jacoco.report.html.HTMLFormatter;

final class Ipfs
implements CoverageService {
    private static final String ROOT_DIR = "report";
    private final WebTarget target;

    Ipfs(WebTarget target) {
        this.target = target;
    }

    @Override
    public String getName() {
        return "IPFS";
    }

    @Override
    public boolean isEnabled(TravisContext travisContext) {
        try {
            this.target.path("api/v0/id").request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).get(JsonObject.class);
            return true;
        }
        catch (ProcessingException ex) {
            if (ex.getCause() instanceof ConnectException) {
                return false;
            }
            throw ex;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String upload(TravisContext travisContext, CoverageContext coverageContext) throws MojoFailureException {
        FormDataMultiPart multipart = new FormDataMultiPart();
        multipart.bodyPart((BodyPart)new FormDataBodyPart(((FormDataContentDisposition.FormDataContentDispositionBuilder)FormDataContentDisposition.name((String)"file").fileName(ROOT_DIR)).build(), (Object)new byte[0], new MediaType("application", "x-directory")));
        HTMLFormatter htmlFormatter = new HTMLFormatter();
        htmlFormatter.setOutputEncoding("utf-8");
        htmlFormatter.setLocale(Locale.ENGLISH);
        try {
            coverageContext.visit(htmlFormatter.createVisitor((IMultiReportOutput)new MultiReportOutput((path, content) -> multipart.bodyPart((BodyPart)new FormDataBodyPart(((FormDataContentDisposition.FormDataContentDispositionBuilder)FormDataContentDisposition.name((String)"file").fileName("report/" + path)).build(), content, MediaType.APPLICATION_OCTET_STREAM_TYPE)))));
        }
        catch (IOException ex) {
            throw new MojoFailureException(String.format("Failed to generate coverage report: %s", ex.getMessage()), (Throwable)ex);
        }
        String response = (String)this.target.path("api/v0/add").queryParam("progress", new Object[]{"false"}).request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).header("Expect", (Object)"100-continue").post(Entity.entity((Object)multipart, (MediaType)multipart.getMediaType()), String.class);
        try (BufferedReader reader = new BufferedReader(new StringReader(response));){
            String line;
            JsonObject object;
            do {
                if ((line = reader.readLine()) == null) throw new MojoFailureException("Failed to extract hash from IPFS response");
            } while (!(object = Json.createReader((Reader)new StringReader(line)).readObject()).getString("Name").equals(ROOT_DIR));
            String string = String.format("https://ipfs.io/ipfs/%s/index.html", object.getString("Hash"));
            return string;
        }
        catch (IOException ex) {
            throw new Error(ex);
        }
    }
}

