/*
 * Decompiled with CFR 0.152.
 */
package org.tinyradius.attribute;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.tinyradius.attribute.IntegerAttribute;
import org.tinyradius.attribute.IpAttribute;
import org.tinyradius.attribute.Ipv6PrefixAttribute;
import org.tinyradius.attribute.RadiusAttribute;
import org.tinyradius.attribute.StringAttribute;
import org.tinyradius.attribute.VendorSpecificAttribute;
import org.tinyradius.dictionary.Dictionary;

public class AttributeType {
    private final int vendorId;
    private final int typeCode;
    private final String name;
    private final String dataType;
    private final ByteArrayConstructor<RadiusAttribute> byteArrayConstructor;
    private final StringConstructor<RadiusAttribute> stringConstructor;
    private final Map<Integer, String> int2str = new HashMap<Integer, String>();
    private final Map<String, Integer> str2int = new HashMap<String, Integer>();

    public AttributeType(int attributeType, String name, String typeStr) {
        this(-1, attributeType, name, typeStr);
    }

    public AttributeType(int vendorId, int attributeType, String name, String rawDataType) {
        if (attributeType < 1 || attributeType > 255) {
            throw new IllegalArgumentException("attribute type code out of bounds");
        }
        if (name == null || name.isEmpty()) {
            throw new IllegalArgumentException("name is empty");
        }
        Objects.requireNonNull(rawDataType, "data type is null");
        this.vendorId = vendorId;
        this.typeCode = attributeType;
        this.name = name;
        this.dataType = rawDataType.toLowerCase();
        if (this.dataType.equals("vsa") || attributeType == 26) {
            this.byteArrayConstructor = VendorSpecificAttribute::new;
            this.stringConstructor = VendorSpecificAttribute::new;
            return;
        }
        switch (this.dataType) {
            case "string": {
                this.byteArrayConstructor = StringAttribute::new;
                this.stringConstructor = StringAttribute::new;
                break;
            }
            case "integer": 
            case "date": {
                this.byteArrayConstructor = IntegerAttribute::new;
                this.stringConstructor = IntegerAttribute::new;
                break;
            }
            case "ipaddr": {
                this.byteArrayConstructor = IpAttribute.V4::new;
                this.stringConstructor = IpAttribute.V4::new;
                break;
            }
            case "ipv6addr": {
                this.byteArrayConstructor = IpAttribute.V6::new;
                this.stringConstructor = IpAttribute.V6::new;
                break;
            }
            case "ipv6prefix": {
                this.byteArrayConstructor = Ipv6PrefixAttribute::new;
                this.stringConstructor = Ipv6PrefixAttribute::new;
                break;
            }
            default: {
                this.byteArrayConstructor = RadiusAttribute::new;
                this.stringConstructor = RadiusAttribute::new;
            }
        }
    }

    public RadiusAttribute create(Dictionary dictionary, byte[] data) {
        return this.byteArrayConstructor.newInstance(dictionary, this.vendorId, this.typeCode, data);
    }

    public RadiusAttribute create(Dictionary dictionary, String data) {
        return this.stringConstructor.newInstance(dictionary, this.vendorId, this.typeCode, data);
    }

    public int getTypeCode() {
        return this.typeCode;
    }

    public String getName() {
        return this.name;
    }

    public int getVendorId() {
        return this.vendorId;
    }

    public String getDataType() {
        return this.dataType;
    }

    public String getEnumeration(int value) {
        return this.int2str.get(value);
    }

    public Integer getEnumeration(String value) {
        return this.str2int.get(value);
    }

    public void addEnumerationValue(int num, String name) {
        if (name == null || name.isEmpty()) {
            throw new IllegalArgumentException("name is empty");
        }
        this.int2str.put(num, name);
        this.str2int.put(name, num);
    }

    public String toString() {
        String s = this.getTypeCode() + "/" + this.getName() + ": " + this.dataType;
        if (this.getVendorId() != -1) {
            s = s + " (vendor " + this.getVendorId() + ")";
        }
        return s;
    }

    public static interface StringConstructor<T extends RadiusAttribute> {
        public T newInstance(Dictionary var1, int var2, int var3, String var4);
    }

    public static interface ByteArrayConstructor<T extends RadiusAttribute> {
        public T newInstance(Dictionary var1, int var2, int var3, byte[] var4);
    }
}

