/*
 * Decompiled with CFR 0.152.
 */
package org.tinyradius.client.handler;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.socket.DatagramPacket;
import io.netty.handler.codec.MessageToMessageCodec;
import java.net.InetSocketAddress;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinyradius.client.PendingRequestCtx;
import org.tinyradius.packet.PacketEncoder;
import org.tinyradius.packet.RadiusPacket;
import org.tinyradius.util.RadiusPacketException;

@ChannelHandler.Sharable
public class ClientPacketCodec
extends MessageToMessageCodec<DatagramPacket, PendingRequestCtx> {
    private static final Logger logger = LoggerFactory.getLogger(ClientPacketCodec.class);
    private final PacketEncoder packetEncoder;

    public ClientPacketCodec(PacketEncoder packetEncoder) {
        this.packetEncoder = packetEncoder;
    }

    protected DatagramPacket encodePacket(InetSocketAddress localAddress, PendingRequestCtx msg) {
        RadiusPacket packet = msg.getRequest().encodeRequest(msg.getEndpoint().getSecret());
        try {
            DatagramPacket datagramPacket = this.packetEncoder.toDatagram(packet, msg.getEndpoint().getAddress(), localAddress);
            logger.debug("Sending request to {}", (Object)msg.getEndpoint().getAddress());
            return datagramPacket;
        }
        catch (RadiusPacketException e) {
            logger.warn("Could not encode Radius packet: {}", (Object)e.getMessage());
            msg.getResponse().tryFailure((Throwable)e);
            return null;
        }
    }

    protected RadiusPacket decodePacket(DatagramPacket msg) {
        InetSocketAddress remoteAddress = (InetSocketAddress)msg.sender();
        if (remoteAddress == null) {
            logger.warn("Ignoring request, remoteAddress is null");
            return null;
        }
        try {
            RadiusPacket packet = this.packetEncoder.fromDatagram(msg);
            logger.debug("Received packet from {} - {}", (Object)remoteAddress, (Object)packet);
            return packet;
        }
        catch (RadiusPacketException e) {
            logger.warn("Could not decode Radius packet: {}", (Object)e.getMessage());
            return null;
        }
    }

    protected void encode(ChannelHandlerContext ctx, PendingRequestCtx msg, List<Object> out) {
        DatagramPacket datagramPacket = this.encodePacket((InetSocketAddress)ctx.channel().localAddress(), msg);
        if (datagramPacket != null) {
            out.add(datagramPacket);
        }
    }

    protected void decode(ChannelHandlerContext ctx, DatagramPacket msg, List<Object> out) {
        RadiusPacket radiusPacket = this.decodePacket(msg);
        if (radiusPacket != null) {
            out.add(radiusPacket);
        }
    }
}

