/*
 * Decompiled with CFR 0.152.
 */
package org.tinyradius.packet;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.socket.DatagramPacket;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import org.tinyradius.attribute.Attributes;
import org.tinyradius.dictionary.Dictionary;
import org.tinyradius.packet.RadiusPacket;
import org.tinyradius.packet.RadiusPackets;
import org.tinyradius.util.RadiusPacketException;

public class PacketEncoder {
    private static final int MAX_PACKET_LENGTH = 4096;
    private final Dictionary dictionary;

    public PacketEncoder(Dictionary dictionary) {
        this.dictionary = dictionary;
    }

    public DatagramPacket toDatagram(RadiusPacket packet, InetSocketAddress recipient) throws RadiusPacketException {
        return new DatagramPacket(this.toByteBuf(packet), recipient);
    }

    public DatagramPacket toDatagram(RadiusPacket packet, InetSocketAddress recipient, InetSocketAddress sender) throws RadiusPacketException {
        return new DatagramPacket(this.toByteBuf(packet), recipient, sender);
    }

    public ByteBuf toByteBuf(RadiusPacket packet) throws RadiusPacketException {
        byte[] attributes = packet.getAttributeBytes();
        int length = 20 + attributes.length;
        if (length > 4096) {
            throw new RadiusPacketException("Packet too long");
        }
        if (packet.getAuthenticator() == null) {
            throw new RadiusPacketException("Missing authenticator");
        }
        if (packet.getAuthenticator().length != 16) {
            throw new RadiusPacketException("Authenticator must be length 16");
        }
        ByteBuf buf = Unpooled.buffer((int)length, (int)length);
        buf.writeByte(packet.getType());
        buf.writeByte(packet.getIdentifier());
        buf.writeShort(length);
        buf.writeBytes(packet.getAuthenticator());
        buf.writeBytes(attributes);
        return buf;
    }

    public RadiusPacket fromDatagram(DatagramPacket datagram) throws RadiusPacketException {
        return this.fromByteBuf((ByteBuf)datagram.content());
    }

    public RadiusPacket fromDatagram(DatagramPacket packet, String sharedSecret) throws RadiusPacketException {
        RadiusPacket radiusPacket = this.fromByteBuf((ByteBuf)packet.content());
        radiusPacket.verify(sharedSecret, new byte[16]);
        return radiusPacket;
    }

    public RadiusPacket fromDatagram(DatagramPacket datagram, String sharedSecret, RadiusPacket request) throws RadiusPacketException {
        RadiusPacket radiusPacket = this.fromByteBuf((ByteBuf)datagram.content(), request.getIdentifier());
        radiusPacket.verify(sharedSecret, request.getAuthenticator());
        return radiusPacket;
    }

    public RadiusPacket fromByteBuf(ByteBuf byteBuf) throws RadiusPacketException {
        return this.fromByteBuf(byteBuf, -1);
    }

    private RadiusPacket fromByteBuf(ByteBuf byteBuf, int requestId) throws RadiusPacketException {
        ByteBuffer content = byteBuf.nioBuffer();
        if (content.remaining() < 20) {
            throw new RadiusPacketException("Readable bytes is less than header length");
        }
        int type = Byte.toUnsignedInt(content.get());
        int packetId = Byte.toUnsignedInt(content.get());
        short length = content.getShort();
        if (requestId != -1 && requestId != packetId) {
            throw new RadiusPacketException("Bad packet: invalid packet identifier - request: " + requestId + ", response: " + packetId);
        }
        if (length < 20) {
            throw new RadiusPacketException("Bad packet: packet too short (" + length + " bytes)");
        }
        if (length > 4096) {
            throw new RadiusPacketException("Bad packet: packet too long (" + length + " bytes)");
        }
        byte[] authenticator = new byte[16];
        content.get(authenticator);
        if (content.remaining() != length - 20) {
            throw new RadiusPacketException("Bad packet: packet length mismatch");
        }
        byte[] attributes = new byte[content.remaining()];
        content.get(attributes);
        return RadiusPackets.create(this.dictionary, type, packetId, authenticator, Attributes.extractAttributes(this.dictionary, -1, attributes, 0));
    }
}

